/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.blocklocker.impl.event;

import java.util.Optional;
import nl.rutgerkok.blocklocker.SignType;
import nl.rutgerkok.blocklocker.Translator;
import nl.rutgerkok.blocklocker.event.PlayerProtectionCreateEvent;
import nl.rutgerkok.blocklocker.impl.BlockLockerPluginImpl;
import nl.rutgerkok.blocklocker.impl.event.EventListener;
import nl.rutgerkok.blocklocker.location.IllegalLocationException;
import nl.rutgerkok.blocklocker.profile.PlayerProfile;
import nl.rutgerkok.blocklocker.profile.Profile;
import nl.rutgerkok.blocklocker.protection.Protection;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.SignChangeEvent;

public class SignChangeListener
extends EventListener {
    public SignChangeListener(BlockLockerPluginImpl plugin) {
        super(plugin);
    }

    private Optional<SignType> getExistingSignType(Block block, Side side) {
        BlockState blockState = block.getState();
        if (blockState instanceof Sign) {
            return this.plugin.getSignParser().getSignType((Sign)blockState, side);
        }
        return Optional.empty();
    }

    private void handleSignNearbyProtection(SignChangeEvent event, Protection protection) {
        Block block = event.getBlock();
        Player player = event.getPlayer();
        PlayerProfile playerProfile = this.plugin.getProfileFactory().fromPlayer(player);
        Optional<SignType> newSignType = this.plugin.getSignParser().getSignType(event);
        Optional<SignType> oldSignType = this.getExistingSignType(event.getBlock(), event.getSide());
        if (!newSignType.isPresent() && !oldSignType.isPresent()) {
            return;
        }
        if (oldSignType.isPresent() && !oldSignType.equals(newSignType)) {
            event.setLine(0, ChatColor.stripColor((String)this.plugin.getChestSettings().getFancyLocalizedHeader(oldSignType.get(), event.getLine(0))));
            newSignType = oldSignType;
        }
        if (!protection.isOwner(playerProfile) && !player.hasPermission("blocklocker.admin")) {
            this.plugin.getTranslator().sendMessage((CommandSender)player, Translator.Translation.PROTECTION_CANNOT_CHANGE_SIGN);
            event.setCancelled(true);
            return;
        }
        if (newSignType.filter(SignType::isMainSign).isPresent()) {
            if (oldSignType.isPresent()) {
                Optional<Profile> owner;
                if (!player.hasPermission("blocklocker.admin") && (owner = protection.getOwner()).isPresent() && !event.getLine(1).equals(owner.get().getDisplayName())) {
                    if (!event.getLine(1).strip().equals(owner.get().getDisplayName().strip())) {
                        this.plugin.getTranslator().sendMessage((CommandSender)player, Translator.Translation.COMMAND_CANNOT_EDIT_OWNER);
                    }
                    event.setLine(1, owner.get().getDisplayName());
                }
            } else {
                this.plugin.getTranslator().sendMessage((CommandSender)player, Translator.Translation.PROTECTION_ADD_MORE_USERS_SIGN_INSTEAD);
                block.breakNaturally();
                event.setCancelled(true);
                return;
            }
        }
        this.updateBlockForUniqueIdsSoon(block);
    }

    private void handleSignNotNearbyProtection(SignChangeEvent event) {
        Optional<SignType> parsedSign = this.plugin.getSignParser().getSignType(event);
        if (!parsedSign.isPresent()) {
            return;
        }
        SignType signType = parsedSign.get();
        Player player = event.getPlayer();
        Block block = event.getBlock();
        if (!player.hasPermission("blocklocker.protect")) {
            this.plugin.getTranslator().sendMessage((CommandSender)player, Translator.Translation.PROTECTION_NO_PERMISSION_FOR_CLAIM);
            block.breakNaturally();
            event.setCancelled(true);
            return;
        }
        try {
            this.plugin.getLocationCheckers().checkLocationAndPermission(player, block);
        }
        catch (IllegalLocationException e) {
            player.sendMessage(e.getTranslatedMessage(this.plugin.getTranslator()));
            block.breakNaturally();
            event.setCancelled(true);
            return;
        }
        if (!signType.isMainSign()) {
            this.plugin.getTranslator().sendMessage((CommandSender)player, Translator.Translation.PROTECTION_NOT_NEARBY);
            block.breakNaturally();
            event.setCancelled(true);
            return;
        }
        if (!this.plugin.getProtectionFinder().isSignNearbyProtectable(block)) {
            this.plugin.getTranslator().sendMessage((CommandSender)player, Translator.Translation.PROTECTION_NOT_NEARBY);
            block.breakNaturally();
            event.setCancelled(true);
            return;
        }
        if (this.plugin.callEvent(new PlayerProtectionCreateEvent(event.getPlayer(), block)).isCancelled()) {
            block.breakNaturally();
            event.setCancelled(true);
            return;
        }
        event.setLine(1, event.getPlayer().getName());
        this.updateBlockForUniqueIdsSoon(block);
        this.plugin.getTranslator().sendMessage((CommandSender)player, Translator.Translation.PROTECTION_CLAIMED_MANUALLY);
    }

    @EventHandler(ignoreCancelled=true)
    public void onSignChange(SignChangeEvent event) {
        Optional<Protection> protection = this.plugin.getProtectionFinder().findExistingProtectionForNewSign(event.getBlock());
        if (protection.isPresent()) {
            this.handleSignNearbyProtection(event, protection.get());
        } else {
            this.handleSignNotNearbyProtection(event);
        }
    }

    private void updateBlockForUniqueIdsSoon(final Block block) {
        this.plugin.runLater(block, new Runnable(){

            @Override
            public void run() {
                Optional<Protection> protection = SignChangeListener.this.plugin.getProtectionFinder().findProtection(block);
                if (protection.isPresent()) {
                    SignChangeListener.this.plugin.getProtectionUpdater().update(protection.get(), true);
                }
            }
        });
    }
}

