/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.blocklocker.impl.blockfinder;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import nl.rutgerkok.blocklocker.ProtectionSign;
import nl.rutgerkok.blocklocker.SignParser;
import nl.rutgerkok.blocklocker.impl.blockfinder.ConnectedContainersBlockFinder;
import nl.rutgerkok.blocklocker.impl.blockfinder.SeparateContainersBlockFinder;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.type.Chest;
import org.bukkit.block.data.type.Gate;
import org.bukkit.block.data.type.WallSign;

public abstract class BlockFinder {
    public static final BlockFace[] CARDINAL_FACES = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST};
    private static final BlockFace[] SIGN_ATTACHMENT_FACES = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST, BlockFace.UP};
    public static final BlockFace[] VERTICAL_FACES = new BlockFace[]{BlockFace.UP, BlockFace.DOWN};
    public static final BlockFace[] NORTH_EAST_SOUTH_WEST_UP_DOWN = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN};
    protected final SignParser parser;

    public static BlockFinder create(SignParser parser, boolean connectContainers) {
        if (connectContainers) {
            return new ConnectedContainersBlockFinder(parser);
        }
        return new SeparateContainersBlockFinder(parser);
    }

    BlockFinder(SignParser parser) {
        this.parser = (SignParser)Preconditions.checkNotNull((Object)parser);
    }

    public Collection<ProtectionSign> findAttachedSigns(Block block) {
        ArrayList<ProtectionSign> signs = new ArrayList<ProtectionSign>();
        for (BlockFace face : SIGN_ATTACHMENT_FACES) {
            Optional<ProtectionSign> parsedSign;
            Block atPosition = block.getRelative(face);
            Material material = atPosition.getType();
            if (!Tag.WALL_SIGNS.isTagged((Keyed)material) && !Tag.STANDING_SIGNS.isTagged((Keyed)material) || !this.isAttachedSign(atPosition, block) || !(parsedSign = this.parser.parseSign(atPosition)).isPresent()) continue;
            signs.add(parsedSign.get());
        }
        return signs;
    }

    public Collection<ProtectionSign> findAttachedSigns(Collection<Block> blocks) {
        if (blocks.size() == 1) {
            return this.findAttachedSigns(blocks.iterator().next());
        }
        ImmutableSet.Builder signs = ImmutableSet.builder();
        for (Block block : blocks) {
            signs.addAll(this.findAttachedSigns(block));
        }
        return signs.build();
    }

    public abstract List<Block> findContainerNeighbors(Block var1);

    public Block findSupportingBlock(Block block) {
        BlockData data = block.getBlockData();
        if (data instanceof Gate) {
            return block.getRelative(BlockFace.DOWN);
        }
        if (data instanceof Directional) {
            return block.getRelative(((Directional)data).getFacing().getOppositeFace());
        }
        return block.getRelative(BlockFace.DOWN);
    }

    protected BlockFace getChestNeighborFaceOrNull(Block block) {
        BlockData blockData = block.getBlockData();
        if (!(blockData instanceof Chest)) {
            return null;
        }
        Chest chest = (Chest)blockData;
        if (chest.getType() == Chest.Type.SINGLE) {
            return null;
        }
        BlockFace towardsLeft = this.turn90Degrees(chest.getFacing());
        return chest.getType() == Chest.Type.LEFT ? towardsLeft : towardsLeft.getOppositeFace();
    }

    public SignParser getSignParser() {
        return this.parser;
    }

    private boolean isAttachedSign(Block signBlock, Block attachedTo) {
        BlockFace requiredFace = signBlock.getFace(attachedTo);
        BlockData materialData = signBlock.getBlockData();
        BlockFace actualFace = BlockFace.DOWN;
        if (materialData instanceof WallSign) {
            actualFace = ((WallSign)materialData).getFacing().getOppositeFace();
        }
        return actualFace == requiredFace;
    }

    protected BlockFace turn90Degrees(BlockFace face) {
        switch (face) {
            case NORTH: {
                return BlockFace.EAST;
            }
            case EAST: {
                return BlockFace.SOUTH;
            }
            case SOUTH: {
                return BlockFace.WEST;
            }
            case WEST: {
                return BlockFace.NORTH;
            }
        }
        throw new IllegalArgumentException("Cannot handle " + String.valueOf(face));
    }
}

