/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.blocklocker.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import nl.rutgerkok.blocklocker.ProfileFactory;
import nl.rutgerkok.blocklocker.ProtectionSign;
import nl.rutgerkok.blocklocker.ProtectionUpdater;
import nl.rutgerkok.blocklocker.SignParser;
import nl.rutgerkok.blocklocker.profile.PlayerProfile;
import nl.rutgerkok.blocklocker.profile.Profile;
import nl.rutgerkok.blocklocker.protection.Protection;
import org.bukkit.Server;
import org.bukkit.entity.Player;

public class ProtectionUpdaterImpl
implements ProtectionUpdater {
    private final Server server;
    private final SignParser signParser;
    private final ProfileFactory profileFactory;

    public ProtectionUpdaterImpl(Server server, SignParser signParser, ProfileFactory profileFactory) {
        this.server = Objects.requireNonNull(server, "server");
        this.signParser = Objects.requireNonNull(signParser, "signParser");
        this.profileFactory = Objects.requireNonNull(profileFactory, "profileFactory");
    }

    @Nullable
    private PlayerProfile getUpdatedProfile(PlayerProfile profile) {
        if (profile.getUniqueId().isPresent()) {
            Player player = this.server.getPlayer(profile.getUniqueId().get());
            if (player != null && !player.getName().equals(profile.getDisplayName())) {
                return this.profileFactory.fromPlayer(player);
            }
            return null;
        }
        String name = profile.getDisplayName();
        if (name.isEmpty()) {
            return null;
        }
        Player player = this.server.getPlayerExact(name);
        if (player == null) {
            return null;
        }
        return this.profileFactory.fromPlayer(player);
    }

    @Override
    public void update(Protection protection, boolean newProtection) {
        for (ProtectionSign protectionSign : protection.getSigns()) {
            this.updateProtectionSign(protectionSign);
        }
    }

    @Nullable
    private List<Profile> updateProfiles(ProtectionSign protectionSign) {
        ArrayList<Profile> updatedProfiles = null;
        int i = -1;
        for (Profile profile : protectionSign.getProfiles()) {
            PlayerProfile updatedProfile;
            ++i;
            if (!(profile instanceof PlayerProfile) || (updatedProfile = this.getUpdatedProfile((PlayerProfile)profile)) == null) continue;
            if (updatedProfiles == null) {
                updatedProfiles = new ArrayList<Profile>(protectionSign.getProfiles());
            }
            updatedProfiles.set(i, updatedProfile);
        }
        return updatedProfiles;
    }

    private void updateProtectionSign(ProtectionSign protectionSign) {
        List<Profile> updatedProfiles = this.updateProfiles(protectionSign);
        if (updatedProfiles != null) {
            protectionSign = protectionSign.withProfiles(updatedProfiles);
        }
        if (updatedProfiles != null || protectionSign.requiresResave()) {
            this.signParser.saveSign(protectionSign);
        }
    }
}

