/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.blocklocker.impl;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import nl.rutgerkok.blocklocker.ProtectionSign;
import nl.rutgerkok.blocklocker.SignType;
import nl.rutgerkok.blocklocker.profile.Profile;
import org.bukkit.Location;

final class ProtectionSignImpl
implements ProtectionSign {
    private static final int MAX_PROFILES = 6;
    private final SignType signType;
    private final List<Profile> profiles;
    private final Location location;
    private final boolean requiresResave;

    ProtectionSignImpl(Location location, SignType signType, List<Profile> profiles, boolean requiresResave) {
        this.location = location;
        this.signType = (SignType)((Object)Preconditions.checkNotNull((Object)((Object)signType)));
        this.profiles = ImmutableList.copyOf(profiles);
        this.requiresResave = requiresResave;
        if (profiles.isEmpty() || profiles.size() > 6) {
            throw new IllegalArgumentException("Invalid size for profiles collection: " + String.valueOf(profiles));
        }
        if (profiles.indexOf(null) != -1) {
            throw new IllegalArgumentException("Profiles list contains null profile: " + String.valueOf(profiles));
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectionSignImpl)) {
            return false;
        }
        ProtectionSignImpl other = (ProtectionSignImpl)obj;
        if (!Objects.equal((Object)this.location.getWorld(), (Object)other.location.getWorld())) {
            return false;
        }
        if (this.location.getBlockX() != other.location.getBlockX()) {
            return false;
        }
        if (this.location.getBlockY() != other.location.getBlockY()) {
            return false;
        }
        return this.location.getBlockZ() == other.location.getBlockZ();
    }

    @Override
    public Location getLocation() {
        return this.location.clone();
    }

    @Override
    public List<Profile> getProfiles() {
        return this.profiles;
    }

    @Override
    public SignType getType() {
        return this.signType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.location.getBlockX();
        result = 31 * result + this.location.getBlockY();
        result = 31 * result + this.location.getBlockZ();
        return result;
    }

    @Override
    public boolean requiresResave() {
        return this.requiresResave;
    }

    @Override
    public ProtectionSign withProfiles(List<Profile> profiles) {
        return new ProtectionSignImpl(this.location, this.signType, profiles, this.requiresResave);
    }

    @Override
    public ProtectionSign withRequiringResave() {
        return new ProtectionSignImpl(this.location, this.signType, this.profiles, true);
    }
}

