/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.blocklocker.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import nl.rutgerkok.blocklocker.SecretSignEntry;

public final class JsonSecretSignEntry
implements SecretSignEntry {
    private final JsonObject object;

    public JsonSecretSignEntry(JsonObject object) {
        this.object = Objects.requireNonNull(object, "object");
    }

    @Override
    public Optional<Boolean> getBoolean(String key) {
        if (!this.object.has(key)) {
            return Optional.empty();
        }
        return Optional.of(this.object.get(key).getAsBoolean());
    }

    @Override
    public OptionalInt getInteger(String key) {
        if (!this.object.has(key)) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(this.object.get(key).getAsNumber().intValue());
    }

    @Override
    public Optional<String> getString(String key) {
        if (!this.object.has(key)) {
            return Optional.empty();
        }
        return Optional.of(this.object.get(key).getAsString());
    }

    @Override
    public Optional<UUID> getUniqueId(String key) {
        JsonElement uuidObject = this.object.get(key);
        if (uuidObject == null || !uuidObject.isJsonPrimitive() || !uuidObject.getAsJsonPrimitive().isString()) {
            return Optional.empty();
        }
        try {
            UUID uuid = UUID.fromString(uuidObject.getAsString());
            return Optional.of(uuid);
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    @Override
    public void setBoolean(String key, boolean bool) {
        this.object.addProperty(key, Boolean.valueOf(bool));
    }

    @Override
    public void setInteger(String key, int integer) {
        this.object.addProperty(key, (Number)integer);
    }

    @Override
    public void setString(String key, String value) {
        this.object.addProperty(key, value);
    }

    @Override
    public void setUniqueId(String key, UUID uuid) {
        this.object.addProperty(key, uuid.toString());
    }
}

