/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.blocklocker.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import nl.rutgerkok.blocklocker.Translator;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

class ConfigTranslator
extends Translator {
    private boolean needsSave = false;
    private final Map<Translator.Translation, TranslationValue> translations = new EnumMap<Translator.Translation, TranslationValue>(Translator.Translation.class);

    ConfigTranslator(ConfigurationSection config) {
        for (Translator.Translation translation : Translator.Translation.values()) {
            Object value;
            String key = translation.toString();
            if (!config.contains(key, true)) {
                this.needsSave = true;
            }
            if ((value = config.get(key)) instanceof String) {
                this.translations.put(translation, new TranslationValue((String)value));
                continue;
            }
            if (this.isStringList(value)) {
                List stringList = (List)value;
                this.translations.put(translation, new MultiTranslationValue(stringList));
                continue;
            }
            this.translations.put(translation, new TranslationValue("~~TODO translate " + key + "~~"));
        }
    }

    @Override
    public String get(Translator.Translation key) {
        return this.translations.get((Object)((Object)key)).colored;
    }

    @Override
    public List<String> getAll(Translator.Translation key) {
        ArrayList<String> all = new ArrayList<String>();
        this.translations.get((Object)key).getAll().forEach(value -> all.add(value.colored));
        return all;
    }

    @Override
    public List<String> getAllWithoutColor(Translator.Translation key) {
        ArrayList<String> all = new ArrayList<String>();
        this.translations.get((Object)key).getAll().forEach(value -> all.add(value.uncolored));
        return all;
    }

    @Override
    public String getWithoutColor(Translator.Translation key) {
        return this.translations.get((Object)((Object)key)).uncolored;
    }

    private boolean isStringList(Object value) {
        if (!(value instanceof List)) {
            return false;
        }
        List list = (List)value;
        for (Object element : list) {
            if (element instanceof String) continue;
            return false;
        }
        return true;
    }

    boolean needsSave() {
        return this.needsSave;
    }

    void save(File file) throws IOException {
        YamlConfiguration config = new YamlConfiguration();
        for (Map.Entry<Translator.Translation, TranslationValue> translationEntry : this.translations.entrySet()) {
            String key = translationEntry.getKey().toString();
            List<TranslationValue> values = translationEntry.getValue().getAll();
            if (values.size() == 1) {
                config.set(key, (Object)translationEntry.getValue().original);
                continue;
            }
            List stringValues = values.stream().map(value -> value.original).collect(Collectors.toList());
            config.set(key, stringValues);
        }
        config.save(file);
        this.needsSave = false;
    }

    @Override
    public void sendMessage(CommandSender player, Translator.Translation translation) {
        String string = this.get(translation);
        if (!string.isEmpty()) {
            player.sendMessage(string);
        }
    }

    private static class TranslationValue {
        private final String original;
        private final String uncolored;
        private final String colored;

        private TranslationValue(String original) {
            this.original = original.trim();
            this.colored = ChatColor.translateAlternateColorCodes((char)'&', (String)original);
            this.uncolored = ChatColor.stripColor((String)this.colored);
        }

        public List<TranslationValue> getAll() {
            return Arrays.asList(this);
        }
    }

    private static class MultiTranslationValue
    extends TranslationValue {
        private final List<TranslationValue> aliases = new ArrayList<TranslationValue>();

        private MultiTranslationValue(List<String> values) {
            super(values.get(0));
            for (String alias : values.subList(1, values.size())) {
                this.aliases.add(new TranslationValue(alias));
            }
        }

        @Override
        public List<TranslationValue> getAll() {
            ArrayList<TranslationValue> all = new ArrayList<TranslationValue>();
            all.add(this);
            this.aliases.forEach(value -> all.add((TranslationValue)value));
            return all;
        }
    }
}

