/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.blocklocker.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.rutgerkok.blocklocker.AttackType;
import nl.rutgerkok.blocklocker.ProtectionType;
import nl.rutgerkok.blocklocker.impl.updater.UpdatePreference;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.Nullable;

final class Config {
    static final String DEFAULT_TRANSLATIONS_FILE = "translations-en.yml";
    private final Set<AttackType> allowDestroyBy;
    private final int autoExpireDays;
    private final boolean connectContainers;
    private final int defaultDoorOpenSeconds;
    private final String languageFile;
    private final Logger logger;
    private final Map<ProtectionType, Set<Material>> protectableMaterialsMap;
    private final Set<Material> protectableMaterialsSet;
    private final UpdatePreference updatePreference;

    Config(Plugin plugin) {
        FileConfiguration config = plugin.getConfig();
        this.logger = plugin.getLogger();
        this.languageFile = config.getString("languageFile", DEFAULT_TRANSLATIONS_FILE);
        this.defaultDoorOpenSeconds = config.getInt("defaultDoorOpenSeconds", 0);
        this.updatePreference = this.readUpdatePreference(config.getString("updater"));
        this.connectContainers = config.getBoolean("connectContainers");
        this.autoExpireDays = config.getInt("autoExpireDays");
        this.allowDestroyBy = this.readAttackTypeSet(config.getStringList("allowDestroyBy"));
        this.protectableMaterialsMap = new EnumMap<ProtectionType, Set<Material>>(ProtectionType.class);
        this.protectableMaterialsMap.put(ProtectionType.CONTAINER, this.readMaterialSet(config.getStringList("protectableContainers")));
        this.protectableMaterialsMap.put(ProtectionType.DOOR, this.readMaterialSet(config.getStringList("protectableDoors")));
        if (config.contains("protectableTrapDoors")) {
            this.protectableMaterialsMap.put(ProtectionType.ATTACHABLE, this.readMaterialSet(config.getStringList("protectableTrapDoors")));
        } else {
            this.protectableMaterialsMap.put(ProtectionType.ATTACHABLE, this.readMaterialSet(config.getStringList("protectableAttachables")));
        }
        this.protectableMaterialsSet = new HashSet<Material>();
        for (Set<Material> protectableByType : this.protectableMaterialsMap.values()) {
            this.protectableMaterialsSet.addAll(protectableByType);
        }
        int version = config.getInt("configVersion", 1);
        if (version < 2) {
            this.logger.info("Upgrading configuration...");
            try (InputStream configStream = Objects.requireNonNull(plugin.getResource("config.yml"));){
                config = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(configStream, StandardCharsets.UTF_8));
                this.writeToConfig(config);
                config.save(new File(plugin.getDataFolder(), "config.yml"));
                plugin.reloadConfig();
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "Failed to read default config", e);
            }
        }
    }

    private void writeToConfig(FileConfiguration config) {
        config.set("languageFile", (Object)this.languageFile);
        config.set("defaultDoorOpenSeconds", (Object)this.defaultDoorOpenSeconds);
        config.set("updater", (Object)this.updatePreference.toString());
        config.set("connectContainers", (Object)this.connectContainers);
        config.set("autoExpireDays", (Object)this.autoExpireDays);
        config.set("allowDestroyBy", this.allowDestroyBy.stream().map(Enum::toString).toList());
        config.set("protectableContainers", this.writeMaterialSet(this.protectableMaterialsMap.get((Object)ProtectionType.CONTAINER)));
        config.set("protectableDoors", this.writeMaterialSet(this.protectableMaterialsMap.get((Object)ProtectionType.DOOR)));
        config.set("protectableAttachables", this.writeMaterialSet(this.protectableMaterialsMap.get((Object)ProtectionType.ATTACHABLE)));
    }

    private List<String> writeMaterialSet(@Nullable Set<Material> materials) {
        if (materials == null) {
            return Collections.emptyList();
        }
        return materials.stream().map(mat -> mat.getKey().toString()).toList();
    }

    boolean allowDestroyBy(AttackType attackType) {
        return this.allowDestroyBy.contains((Object)attackType);
    }

    boolean canProtect(Block block) {
        return this.protectableMaterialsSet.contains(block.getType());
    }

    boolean canProtect(ProtectionType type, Block block) {
        Set<Material> materials = this.protectableMaterialsMap.get((Object)type);
        if (materials == null) {
            return false;
        }
        return materials.contains(block.getType());
    }

    int getAutoExpireDays() {
        return this.autoExpireDays;
    }

    boolean getConnectContainers() {
        return this.connectContainers;
    }

    int getDefaultDoorOpenSeconds() {
        return this.defaultDoorOpenSeconds;
    }

    String getLanguageFileName() {
        return this.languageFile;
    }

    UpdatePreference getUpdatePreference() {
        return this.updatePreference;
    }

    private Set<AttackType> readAttackTypeSet(List<String> strings) {
        EnumSet<AttackType> materials = EnumSet.noneOf(AttackType.class);
        for (String string : strings) {
            try {
                materials.add(AttackType.valueOf(string.toUpperCase(Locale.ROOT)));
            }
            catch (IllegalArgumentException e) {
                this.logger.warning("Cannot recognize attack type " + string + ", ignoring it");
            }
        }
        return materials;
    }

    private Set<Material> readMaterialSet(Collection<String> strings) {
        HashSet<Material> materials = new HashSet<Material>();
        for (String string : strings) {
            Material material = Material.matchMaterial((String)string);
            if (material == null) {
                material = Material.matchMaterial((String)string, (boolean)true);
            }
            if (material == null) {
                this.logger.warning("Cannot recognize material " + string + ", ignoring it");
                continue;
            }
            materials.add(material);
        }
        return materials;
    }

    private UpdatePreference readUpdatePreference(String string) {
        Optional<UpdatePreference> updatePreference = UpdatePreference.parse(string);
        if (updatePreference.isPresent()) {
            return updatePreference.get();
        }
        this.logger.warning("Unknown update setting: " + string + ". Disabling automatic updater.");
        return UpdatePreference.DISABLED;
    }

    private static final class Key {
        private static final String LANGUAGE_FILE = "languageFile";
        private static final String PROTECTABLE_CONTAINERS = "protectableContainers";
        private static final String PROTECTABLE_DOORS = "protectableDoors";
        private static final String PROTECTABLE_TRAP_DOORS = "protectableTrapDoors";
        private static final String PROTECTABLE_ATTACHABLES = "protectableAttachables";
        private static final String DEFAULT_DOOR_OPEN_SECONDS = "defaultDoorOpenSeconds";
        private static final String UPDATER = "updater";
        private static final String CONNECT_CONTAINERS = "connectContainers";
        private static final String AUTO_EXPIRE_DAYS = "autoExpireDays";
        private static final String ALLOW_DESTROY_BY = "allowDestroyBy";
        private static final String CONFIG_VERSION = "configVersion";

        private Key() {
        }
    }
}

