/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.blocklocker.impl;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.Nullable;
import nl.rutgerkok.blocklocker.OpenBlockSound;
import nl.rutgerkok.blocklocker.protection.Protection;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Door;

public final class CompleteDoor {
    private final Material doorMaterial;
    private final Block topLeftBlock;
    private final Block topRightBlock;
    private final Block bottomLeftBlock;
    private final Block bottomRightBlock;

    private static Door asDoorMaterialOrNull(Block nullableBlock) {
        if (nullableBlock == null) {
            return null;
        }
        BlockData materialData = nullableBlock.getBlockData();
        if (materialData instanceof Door) {
            return (Door)materialData;
        }
        return null;
    }

    private static BlockFace getFaceOrNull(Block doorBlock) {
        Door door = CompleteDoor.asDoorMaterialOrNull(doorBlock);
        if (door == null) {
            return null;
        }
        return door.getFacing();
    }

    @Nullable
    private static BlockFace getFaceToLeftDoorOrNull(Block bottomHalfDoorBlock) {
        BlockFace rightDoor = CompleteDoor.getFaceToRightDoorOrNull(bottomHalfDoorBlock);
        if (rightDoor == null) {
            return null;
        }
        return rightDoor.getOppositeFace();
    }

    @Nullable
    private static BlockFace getFaceToRightDoorOrNull(Block bottomHalfDoorBlock) {
        Door door = CompleteDoor.asDoorMaterialOrNull(bottomHalfDoorBlock);
        if (door == null) {
            return null;
        }
        switch (door.getFacing()) {
            case EAST: {
                return BlockFace.SOUTH;
            }
            case SOUTH: {
                return BlockFace.WEST;
            }
            case WEST: {
                return BlockFace.NORTH;
            }
            case NORTH: {
                return BlockFace.EAST;
            }
        }
        throw new RuntimeException("Invalid facing for door: " + String.valueOf(door));
    }

    private static Hinge getHinge(Block topHalfDoorBlock) {
        Door door = CompleteDoor.asDoorMaterialOrNull(topHalfDoorBlock);
        if (door != null) {
            return door.getHinge() == Door.Hinge.LEFT ? Hinge.LEFT : Hinge.RIGHT;
        }
        return Hinge.UNKNOWN;
    }

    @Nullable
    private static Block getRelativeOrNull(@Nullable Block block, @Nullable BlockFace face) {
        if (block == null || face == null) {
            return null;
        }
        return block.getRelative(face);
    }

    private static boolean isTopHalf(Block doorBlock) {
        Door door = CompleteDoor.asDoorMaterialOrNull(doorBlock);
        if (door != null) {
            return door.getHalf() == Bisected.Half.TOP;
        }
        return false;
    }

    public CompleteDoor(Block doorBlock) {
        Block bottomBlock;
        Block topBlock;
        this.doorMaterial = doorBlock.getType();
        BlockFace doorFace = CompleteDoor.getFaceOrNull(doorBlock);
        if (CompleteDoor.isTopHalf(doorBlock)) {
            topBlock = doorBlock;
            bottomBlock = doorBlock.getRelative(BlockFace.DOWN);
        } else {
            bottomBlock = doorBlock;
            topBlock = doorBlock.getRelative(BlockFace.UP);
        }
        Hinge hinge = CompleteDoor.getHinge(topBlock);
        if (hinge == Hinge.LEFT) {
            this.topLeftBlock = this.asDoorBlockOrNull(topBlock);
            this.bottomLeftBlock = this.asDoorBlockOrNull(bottomBlock);
            BlockFace faceToRightDoor = CompleteDoor.getFaceToRightDoorOrNull(bottomBlock);
            this.topRightBlock = this.asDoorBlockOrNull(CompleteDoor.getRelativeOrNull(topBlock, faceToRightDoor), Hinge.RIGHT, doorFace);
            this.bottomRightBlock = this.asDoorBlockOrNull(CompleteDoor.getRelativeOrNull(bottomBlock, faceToRightDoor), Hinge.RIGHT, doorFace);
        } else if (hinge == Hinge.RIGHT) {
            this.topRightBlock = this.asDoorBlockOrNull(topBlock);
            this.bottomRightBlock = this.asDoorBlockOrNull(bottomBlock);
            BlockFace faceToLeftDoor = CompleteDoor.getFaceToLeftDoorOrNull(bottomBlock);
            this.topLeftBlock = this.asDoorBlockOrNull(CompleteDoor.getRelativeOrNull(topBlock, faceToLeftDoor), Hinge.LEFT, doorFace);
            this.bottomLeftBlock = this.asDoorBlockOrNull(CompleteDoor.getRelativeOrNull(bottomBlock, faceToLeftDoor), Hinge.LEFT, doorFace);
        } else {
            this.topLeftBlock = null;
            this.topRightBlock = null;
            this.bottomLeftBlock = null;
            this.bottomRightBlock = null;
        }
    }

    private Block asDoorBlockOrNull(Block nullableBlock) {
        if (nullableBlock != null && nullableBlock.getType() == this.doorMaterial) {
            return nullableBlock;
        }
        return null;
    }

    @Nullable
    private Block asDoorBlockOrNull(@Nullable Block nullableBlock, @Nullable Hinge expectedHinge, @Nullable BlockFace expectedFace) {
        if (nullableBlock != null && nullableBlock.getType() == this.doorMaterial) {
            Door door = CompleteDoor.asDoorMaterialOrNull(nullableBlock);
            if (door.getFacing() != expectedFace) {
                return null;
            }
            switch (door.getHinge()) {
                case LEFT: {
                    if (expectedHinge != Hinge.LEFT) break;
                    return nullableBlock;
                }
                case RIGHT: {
                    if (expectedHinge != Hinge.RIGHT) break;
                    return nullableBlock;
                }
            }
        }
        return null;
    }

    public Collection<Block> getBlocksForSigns() {
        BlockFace toLeft = this.getFaceToLeftDoor();
        BlockFace toRight = toLeft.getOppositeFace();
        ImmutableList.Builder blocks = ImmutableList.builder();
        if (this.bottomLeftBlock != null) {
            blocks.add((Object)this.bottomLeftBlock);
            blocks.add((Object)this.bottomLeftBlock.getRelative(BlockFace.DOWN));
            blocks.add((Object)this.bottomLeftBlock.getRelative(toLeft));
            if (this.bottomRightBlock == null) {
                blocks.add((Object)this.bottomLeftBlock.getRelative(toRight));
            }
        }
        if (this.bottomRightBlock != null) {
            blocks.add((Object)this.bottomRightBlock);
            blocks.add((Object)this.bottomRightBlock.getRelative(BlockFace.DOWN));
            blocks.add((Object)this.bottomRightBlock.getRelative(toRight));
            if (this.bottomLeftBlock == null) {
                blocks.add((Object)this.bottomRightBlock.getRelative(toLeft));
            }
        }
        if (this.topLeftBlock != null) {
            blocks.add((Object)this.topLeftBlock);
            blocks.add((Object)this.topLeftBlock.getRelative(BlockFace.UP));
            blocks.add((Object)this.topLeftBlock.getRelative(toLeft));
            if (this.topRightBlock == null) {
                blocks.add((Object)this.topLeftBlock.getRelative(toRight));
            }
        }
        if (this.topRightBlock != null) {
            blocks.add((Object)this.topRightBlock);
            blocks.add((Object)this.topRightBlock.getRelative(BlockFace.UP));
            blocks.add((Object)this.topRightBlock.getRelative(toRight));
            if (this.topLeftBlock == null) {
                blocks.add((Object)this.topRightBlock.getRelative(toLeft));
            }
        }
        return blocks.build();
    }

    private BlockFace getFaceToLeftDoor() {
        Block bottomBlock = this.asDoorBlockOrNull(this.bottomLeftBlock);
        if (bottomBlock == null && (bottomBlock = this.asDoorBlockOrNull(this.bottomRightBlock)) == null) {
            return BlockFace.SELF;
        }
        return CompleteDoor.getFaceToLeftDoorOrNull(bottomBlock);
    }

    public Block getSomeDoorBlock() {
        if (this.bottomLeftBlock != null) {
            return this.bottomLeftBlock;
        }
        if (this.bottomRightBlock != null) {
            return this.bottomRightBlock;
        }
        if (this.topLeftBlock != null) {
            return this.topLeftBlock;
        }
        if (this.topRightBlock != null) {
            return this.topRightBlock;
        }
        throw new IllegalStateException("All four door blocks where null, this should not be possible");
    }

    public boolean isOpen() {
        BlockData materialData = null;
        if (this.bottomRightBlock != null) {
            materialData = this.bottomRightBlock.getBlockData();
        }
        if (this.bottomLeftBlock != null) {
            materialData = this.bottomLeftBlock.getBlockData();
        }
        return materialData instanceof Door && ((Door)materialData).isOpen();
    }

    private void playSound(Block bottomBlock, boolean open, Protection.SoundCondition condition) {
        boolean ironDoor;
        if (condition == Protection.SoundCondition.NEVER) {
            return;
        }
        if (open == this.isOpen()) {
            return;
        }
        boolean bl = ironDoor = bottomBlock.getType() == Material.IRON_DOOR;
        if (condition == Protection.SoundCondition.AUTOMATIC && !ironDoor) {
            return;
        }
        Sound sound = OpenBlockSound.get(bottomBlock.getType(), open);
        bottomBlock.getWorld().playSound(bottomBlock.getLocation(), sound, 1.0f, 0.7f);
    }

    public void setOpen(boolean open, Protection.SoundCondition soundAction) {
        Door rightDoor;
        Door leftDoor = CompleteDoor.asDoorMaterialOrNull(this.bottomLeftBlock);
        if (leftDoor != null) {
            this.playSound(this.bottomLeftBlock, open, soundAction);
            soundAction = Protection.SoundCondition.NEVER;
            leftDoor.setOpen(open);
            this.bottomLeftBlock.setBlockData((BlockData)leftDoor);
        }
        if ((rightDoor = CompleteDoor.asDoorMaterialOrNull(this.bottomRightBlock)) != null) {
            this.playSound(this.bottomRightBlock, open, soundAction);
            rightDoor.setOpen(open);
            this.bottomRightBlock.setBlockData((BlockData)rightDoor);
        }
    }

    private static enum Hinge {
        LEFT,
        RIGHT,
        UNKNOWN;

    }
}

