/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.blocklocker.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import nl.rutgerkok.blocklocker.AttackType;
import nl.rutgerkok.blocklocker.ChestSettings;
import nl.rutgerkok.blocklocker.ProtectableBlocksSettings;
import nl.rutgerkok.blocklocker.ProtectionType;
import nl.rutgerkok.blocklocker.SignType;
import nl.rutgerkok.blocklocker.Translator;
import nl.rutgerkok.blocklocker.impl.Config;
import org.bukkit.block.Block;

class ChestSettingsImpl
implements ChestSettings {
    private static final ProtectionType[] PROTECTION_TYPES = ProtectionType.values();
    private final Config config;
    private final Translator translator;
    private final List<ProtectableBlocksSettings> extraProtectables = new ArrayList<ProtectableBlocksSettings>();

    ChestSettingsImpl(Translator translator, Config config) {
        this.translator = Objects.requireNonNull(translator, "translator");
        this.config = Objects.requireNonNull(config, "config");
    }

    @Override
    public boolean allowDestroyBy(AttackType attackType) {
        return this.config.allowDestroyBy(attackType);
    }

    @Override
    public boolean canProtect(Block block) {
        if (this.config.canProtect(block)) {
            return true;
        }
        if (!this.extraProtectables.isEmpty()) {
            for (ProtectableBlocksSettings extra : this.extraProtectables) {
                if (!extra.canProtect(block)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canProtect(ProtectionType type, Block block) {
        if (this.config.canProtect(type, block)) {
            return true;
        }
        if (!this.extraProtectables.isEmpty()) {
            for (ProtectableBlocksSettings extra : this.extraProtectables) {
                if (!extra.canProtect(type, block)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Optional<Date> getChestExpireDate() {
        int days = this.config.getAutoExpireDays();
        if (days <= 0) {
            return Optional.empty();
        }
        Calendar calendar = Calendar.getInstance(Locale.US);
        calendar.add(5, -days);
        Date cutoffDate = calendar.getTime();
        return Optional.of(cutoffDate);
    }

    @Override
    public boolean getConnectContainers() {
        return this.config.getConnectContainers();
    }

    @Override
    public int getDefaultDoorOpenSeconds() {
        return this.config.getDefaultDoorOpenSeconds();
    }

    @Override
    public List<ProtectableBlocksSettings> getExtraProtectables() {
        return this.extraProtectables;
    }

    @Override
    public String getFancyLocalizedHeader(SignType signType, String header) {
        List<String> headers = this.translator.getAll(this.getTranslationKey(signType));
        for (String head : headers) {
            if (!head.equalsIgnoreCase(header)) continue;
            return header;
        }
        return this.translator.get(this.getTranslationKey(signType));
    }

    @Override
    public Optional<ProtectionType> getProtectionType(Block block) {
        for (ProtectionType type : PROTECTION_TYPES) {
            if (!this.canProtect(type, block)) continue;
            return Optional.of(type);
        }
        return Optional.empty();
    }

    @Override
    public List<String> getSimpleLocalizedHeaders(SignType signType) {
        return this.translator.getAllWithoutColor(this.getTranslationKey(signType));
    }

    private Translator.Translation getTranslationKey(SignType signType) {
        switch (signType) {
            case MORE_USERS: {
                return Translator.Translation.TAG_MORE_USERS;
            }
            case PRIVATE: {
                return Translator.Translation.TAG_PRIVATE;
            }
        }
        throw new AssertionError((Object)("Unknown type: " + String.valueOf((Object)signType)));
    }
}

