/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.blocklocker.impl;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.logging.Level;
import nl.rutgerkok.blocklocker.BlockLockerPlugin;
import nl.rutgerkok.blocklocker.ChestSettings;
import nl.rutgerkok.blocklocker.ProfileFactory;
import nl.rutgerkok.blocklocker.ProtectableBlocksSettings;
import nl.rutgerkok.blocklocker.ProtectionCache;
import nl.rutgerkok.blocklocker.ProtectionFinder;
import nl.rutgerkok.blocklocker.ProtectionUpdater;
import nl.rutgerkok.blocklocker.SignParser;
import nl.rutgerkok.blocklocker.Translator;
import nl.rutgerkok.blocklocker.group.CombinedGroupSystem;
import nl.rutgerkok.blocklocker.group.GroupSystem;
import nl.rutgerkok.blocklocker.impl.ChestSettingsImpl;
import nl.rutgerkok.blocklocker.impl.Config;
import nl.rutgerkok.blocklocker.impl.ConfigTranslator;
import nl.rutgerkok.blocklocker.impl.HopperCacheImpl;
import nl.rutgerkok.blocklocker.impl.ProtectionFinderImpl;
import nl.rutgerkok.blocklocker.impl.ProtectionUpdaterImpl;
import nl.rutgerkok.blocklocker.impl.SchedulerSupport;
import nl.rutgerkok.blocklocker.impl.SignParserImpl;
import nl.rutgerkok.blocklocker.impl.blockfinder.BlockFinder;
import nl.rutgerkok.blocklocker.impl.event.BlockDestroyListener;
import nl.rutgerkok.blocklocker.impl.event.BlockLockerCommand;
import nl.rutgerkok.blocklocker.impl.event.BlockPlaceListener;
import nl.rutgerkok.blocklocker.impl.event.GolemListener;
import nl.rutgerkok.blocklocker.impl.event.InteractListener;
import nl.rutgerkok.blocklocker.impl.event.SignChangeListener;
import nl.rutgerkok.blocklocker.impl.group.FactionsGroupSystem;
import nl.rutgerkok.blocklocker.impl.group.GuildsGroupSystem;
import nl.rutgerkok.blocklocker.impl.group.PermissionsGroupSystem;
import nl.rutgerkok.blocklocker.impl.group.ScoreboardGroupSystem;
import nl.rutgerkok.blocklocker.impl.group.SimpleClansGroupSystem;
import nl.rutgerkok.blocklocker.impl.group.TownyGroupSystem;
import nl.rutgerkok.blocklocker.impl.group.mcMMOGroupSystem;
import nl.rutgerkok.blocklocker.impl.location.TownyLocationChecker;
import nl.rutgerkok.blocklocker.impl.profile.ProfileFactoryImpl;
import nl.rutgerkok.blocklocker.impl.updater.Updater;
import nl.rutgerkok.blocklocker.location.CombinedLocationChecker;
import nl.rutgerkok.blocklocker.location.LocationChecker;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public class BlockLockerPluginImpl
extends JavaPlugin
implements BlockLockerPlugin {
    private ChestSettings chestSettings;
    private CombinedGroupSystem combinedGroupSystem;
    private Config config;
    private ProfileFactoryImpl profileFactory;
    private ProtectionFinderImpl protectionFinder;
    private ProtectionUpdater protectionUpdater;
    private SignParser signParser;
    private Translator translator;
    private CombinedLocationChecker combinedLocationChecker;
    private SchedulerSupport schedulerSupport;
    private ProtectionCache protectionCache;

    @Override
    public <E extends Event> E callEvent(E event) {
        this.getServer().getPluginManager().callEvent(event);
        return event;
    }

    @Override
    public ChestSettings getChestSettings() {
        return this.chestSettings;
    }

    @Override
    public CombinedGroupSystem getGroupSystems() {
        Preconditions.checkState((this.combinedGroupSystem != null ? 1 : 0) != 0);
        return this.combinedGroupSystem;
    }

    @Override
    public ProtectionCache getProtectionCache() {
        return this.protectionCache;
    }

    private Optional<Configuration> getJarConfig(String path) {
        if (path.contains("/") || path.contains("\\")) {
            return Optional.empty();
        }
        if (!path.toLowerCase(Locale.ROOT).endsWith(".yml")) {
            return Optional.empty();
        }
        InputStream resource = this.getResource(path);
        if (resource == null) {
            return Optional.empty();
        }
        InputStreamReader reader = new InputStreamReader(resource, Charsets.UTF_8);
        YamlConfiguration config = YamlConfiguration.loadConfiguration((Reader)reader);
        try {
            resource.close();
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Failed to close stream", e);
        }
        return Optional.of(config);
    }

    @Override
    public CombinedLocationChecker getLocationCheckers() {
        Preconditions.checkState((this.combinedLocationChecker != null ? 1 : 0) != 0);
        return this.combinedLocationChecker;
    }

    @Override
    public ProfileFactory getProfileFactory() {
        return this.profileFactory;
    }

    @Override
    public ProtectionFinder getProtectionFinder() {
        return this.protectionFinder;
    }

    @Override
    public ProtectionUpdater getProtectionUpdater() {
        return this.protectionUpdater;
    }

    @Override
    public SignParser getSignParser() {
        return this.signParser;
    }

    @Override
    public Translator getTranslator() {
        return this.translator;
    }

    private void loadGroupSystems() {
        this.combinedGroupSystem = new CombinedGroupSystem();
        this.combinedGroupSystem.addSystem(new PermissionsGroupSystem());
        this.combinedGroupSystem.addSystem(new ScoreboardGroupSystem());
        if (FactionsGroupSystem.isAvailable()) {
            this.combinedGroupSystem.addSystem(new FactionsGroupSystem());
        }
        if (TownyGroupSystem.isAvailable()) {
            this.combinedGroupSystem.addSystem(new TownyGroupSystem());
        }
        if (mcMMOGroupSystem.isAvailable()) {
            this.combinedGroupSystem.addSystem(new mcMMOGroupSystem());
        }
        if (GuildsGroupSystem.isAvailable()) {
            this.combinedGroupSystem.addSystem(new GuildsGroupSystem());
        }
        if (SimpleClansGroupSystem.isAvailable()) {
            this.combinedGroupSystem.addSystem(new SimpleClansGroupSystem());
        }
    }

    private void loadLocationCheckers() {
        this.combinedLocationChecker = new CombinedLocationChecker();
        if (TownyLocationChecker.isAvailable()) {
            this.combinedLocationChecker.addChecker(new TownyLocationChecker());
        }
    }

    private void loadServices() {
        this.schedulerSupport = new SchedulerSupport((Plugin)this);
        this.saveDefaultConfig();
        this.config = new Config((Plugin)this);
        this.loadGroupSystems();
        this.loadLocationCheckers();
        this.translator = this.loadTranslations(this.config.getLanguageFileName());
        this.profileFactory = new ProfileFactoryImpl(this.combinedGroupSystem, this.translator);
        this.chestSettings = new ChestSettingsImpl(this.translator, this.config);
        this.signParser = new SignParserImpl(this.chestSettings, this.profileFactory);
        BlockFinder blockFinder = BlockFinder.create(this.signParser, this.config.getConnectContainers());
        this.protectionFinder = new ProtectionFinderImpl(blockFinder, this.chestSettings);
        this.protectionUpdater = new ProtectionUpdaterImpl(this.getServer(), this.signParser, this.profileFactory);
        this.protectionCache = new HopperCacheImpl();
    }

    private Translator loadTranslations(String fileName) {
        File file = new File(this.getDataFolder(), fileName);
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        Optional<Configuration> defaultsForLanguage = this.getJarConfig(fileName);
        if (defaultsForLanguage.isPresent()) {
            config.addDefaults(defaultsForLanguage.get());
        } else {
            Configuration defaultsForEnglish = this.getJarConfig("translations-en.yml").orElseGet(YamlConfiguration::new);
            config.addDefaults(defaultsForEnglish);
        }
        ConfigTranslator translator = new ConfigTranslator((ConfigurationSection)config);
        if (translator.needsSave()) {
            this.getLogger().info("Saving translations");
            try {
                translator.save(file);
            }
            catch (IOException e) {
                this.getLogger().log(Level.SEVERE, "Failed to save translation file", e);
            }
        }
        return translator;
    }

    public void onEnable() {
        this.loadServices();
        this.registerEvents();
        new Updater(this.config.getUpdatePreference(), this.translator, this).startUpdater();
    }

    private void registerEvents() {
        PluginManager plugins = Bukkit.getPluginManager();
        plugins.registerEvents((Listener)new BlockDestroyListener(this), (Plugin)this);
        plugins.registerEvents((Listener)new BlockPlaceListener(this), (Plugin)this);
        plugins.registerEvents((Listener)new InteractListener(this), (Plugin)this);
        plugins.registerEvents((Listener)new GolemListener(this), (Plugin)this);
        plugins.registerEvents((Listener)new SignChangeListener(this), (Plugin)this);
        this.getCommand(this.getName().toLowerCase(Locale.ROOT)).setExecutor((CommandExecutor)new BlockLockerCommand(this));
    }

    @Override
    public void reload() {
        Collection<GroupSystem> keepGroupSystems = this.combinedGroupSystem.getReloadSurvivors();
        Collection<LocationChecker> keepLocationCheckers = this.combinedLocationChecker.getReloadSurvivors();
        List<ProtectableBlocksSettings> keepProtectables = this.chestSettings.getExtraProtectables();
        this.reloadConfig();
        this.loadServices();
        keepGroupSystems.forEach(this.combinedGroupSystem::addSystem);
        keepLocationCheckers.forEach(this.combinedLocationChecker::addChecker);
        this.chestSettings.getExtraProtectables().addAll(keepProtectables);
    }

    @Override
    public void runLater(Block block, Runnable runnable) {
        this.schedulerSupport.runLater(block, runnable);
    }

    @Override
    public void runLater(Block block, Runnable runnable, int ticks) {
        this.schedulerSupport.runLater(block, runnable, ticks);
    }

    @Override
    public void runLaterGlobally(Runnable runnable, int ticks) {
        this.schedulerSupport.runLaterGlobally(runnable, ticks);
    }

    public void runTimerAsync(Consumer<BukkitTask> task, long checkInterval) {
        this.schedulerSupport.runTimerAsync(task, checkInterval);
    }
}

