/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.blocklocker.group;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import nl.rutgerkok.blocklocker.group.GroupSystem;
import org.bukkit.entity.Player;

public final class CombinedGroupSystem
extends GroupSystem {
    private List<GroupSystem> systems = new ArrayList<GroupSystem>();

    public void addSystem(GroupSystem system) {
        this.systems.add((GroupSystem)Preconditions.checkNotNull((Object)system));
    }

    @Deprecated
    public void addSystems(Iterable<GroupSystem> systems) {
        for (GroupSystem system : systems) {
            this.addSystem(system);
        }
    }

    public Collection<GroupSystem> getReloadSurvivors() {
        ArrayList<GroupSystem> reloadSurvivors = new ArrayList<GroupSystem>();
        for (GroupSystem system : this.systems) {
            if (!system.keepOnReload()) continue;
            reloadSurvivors.add(system);
        }
        return reloadSurvivors;
    }

    @Override
    public boolean isGroupLeader(Player player, String groupName) {
        for (GroupSystem system : this.systems) {
            if (!system.isGroupLeader(player, groupName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInGroup(Player player, String groupName) {
        for (GroupSystem system : this.systems) {
            if (!system.isInGroup(player, groupName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean keepOnReload() {
        return false;
    }
}

