/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.blocklocker.impl.updater;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import java.io.IOException;
import nl.rutgerkok.blocklocker.impl.updater.UpdateCheckResult;

final class UpdateResult {
    private final Status status;
    private final UpdateCheckResult checkResult;

    static UpdateResult failed() {
        try {
            return new UpdateResult(Status.CHECK_FAILED, new UpdateCheckResult(new JsonObject()));
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    UpdateResult(Status status, UpdateCheckResult checkResult) {
        this.status = (Status)((Object)Preconditions.checkNotNull((Object)((Object)status)));
        this.checkResult = (UpdateCheckResult)Preconditions.checkNotNull((Object)checkResult);
    }

    Status getStatus() {
        return this.status;
    }

    UpdateCheckResult getUpdateCheckResult() {
        return this.checkResult;
    }

    boolean hasNotification() {
        return this.status.hasNotification();
    }

    static enum Status {
        NO_UPDATE,
        MANUAL_UPDATE,
        CHECK_FAILED,
        UNSUPPORTED_SERVER;


        public boolean hasNotification() {
            return this == MANUAL_UPDATE || this == UNSUPPORTED_SERVER;
        }
    }
}

