/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.blocklocker.impl.protection;

import java.util.Collection;
import nl.rutgerkok.blocklocker.ProtectionSign;
import nl.rutgerkok.blocklocker.impl.CompleteDoor;
import nl.rutgerkok.blocklocker.impl.blockfinder.BlockFinder;
import nl.rutgerkok.blocklocker.impl.protection.AbstractProtection;
import nl.rutgerkok.blocklocker.protection.DoorProtection;
import nl.rutgerkok.blocklocker.protection.Protection;
import org.bukkit.block.Block;

public final class DoorProtectionImpl
extends AbstractProtection
implements DoorProtection {
    private final BlockFinder blockFinder;
    private final CompleteDoor door;

    public static Protection fromDoorWithSign(ProtectionSign sign, BlockFinder blockFinder, CompleteDoor door) {
        return new DoorProtectionImpl(sign, blockFinder, door);
    }

    public static Protection fromDoorWithSigns(Collection<ProtectionSign> signs, BlockFinder blockFinder, CompleteDoor door) {
        return new DoorProtectionImpl(signs, blockFinder, door);
    }

    private DoorProtectionImpl(Collection<ProtectionSign> signs, BlockFinder blockFinder, CompleteDoor door) {
        super(signs);
        this.door = door;
        this.blockFinder = blockFinder;
    }

    private DoorProtectionImpl(ProtectionSign sign, BlockFinder blockFinder, CompleteDoor door) {
        super(sign);
        this.door = door;
        this.blockFinder = blockFinder;
    }

    @Override
    public boolean canBeOpened() {
        return true;
    }

    @Override
    protected Collection<ProtectionSign> fetchSigns() {
        return this.blockFinder.findAttachedSigns(this.door.getBlocksForSigns());
    }

    @Override
    public Block getSomeProtectedBlock() {
        return this.door.getSomeDoorBlock();
    }

    @Override
    public boolean isOpen() {
        return this.door.isOpen();
    }

    @Override
    public void setOpen(boolean open, Protection.SoundCondition playSound) {
        this.door.setOpen(open, playSound);
    }
}

