/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.blocklocker.impl.protection;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import nl.rutgerkok.blocklocker.OpenBlockSound;
import nl.rutgerkok.blocklocker.ProtectionSign;
import nl.rutgerkok.blocklocker.impl.blockfinder.BlockFinder;
import nl.rutgerkok.blocklocker.impl.protection.AbstractProtection;
import nl.rutgerkok.blocklocker.protection.ContainerProtection;
import nl.rutgerkok.blocklocker.protection.Protection;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Openable;

public final class ContainerProtectionImpl
extends AbstractProtection
implements ContainerProtection {
    private final BlockFinder blockFinder;
    private final Collection<Block> blocks;

    public static Protection fromBlocksWithSign(ProtectionSign sign, Collection<Block> blocks, BlockFinder blockFinder) {
        return new ContainerProtectionImpl(sign, blocks, blockFinder);
    }

    public static Protection fromBlocksWithSigns(Collection<ProtectionSign> signs, List<Block> blocks, BlockFinder blockFinder) {
        return new ContainerProtectionImpl(signs, blocks, blockFinder);
    }

    private ContainerProtectionImpl(Collection<ProtectionSign> allSigns, Collection<Block> blocks, BlockFinder blockFinder) {
        super(allSigns);
        this.blocks = blocks;
        this.blockFinder = blockFinder;
    }

    private ContainerProtectionImpl(ProtectionSign mainSign, Collection<Block> blocks, BlockFinder blockFinder) {
        super(mainSign);
        this.blocks = blocks;
        this.blockFinder = blockFinder;
        if (this.blocks.isEmpty()) {
            throw new IllegalArgumentException("Blocks list is empty");
        }
    }

    @Override
    public boolean canBeOpened() {
        Iterator<Block> iterator = this.blocks.iterator();
        if (iterator.hasNext()) {
            Block block = iterator.next();
            return ContainerProtectionImpl.isFunctionalOpenable(block.getBlockData());
        }
        return false;
    }

    @Override
    protected Collection<ProtectionSign> fetchSigns() {
        return this.blockFinder.findAttachedSigns(this.blocks);
    }

    @Override
    public Block getSomeProtectedBlock() {
        Iterator<Block> iterator = this.blocks.iterator();
        if (iterator.hasNext()) {
            Block block = iterator.next();
            return block;
        }
        throw new AssertionError((Object)"Block list was empty, this should have been checked in the constructor");
    }

    @Override
    public boolean isOpen() {
        for (Block block : this.blocks) {
            BlockData materialData = block.getBlockData();
            if (!ContainerProtectionImpl.isFunctionalOpenable(materialData)) continue;
            return ((Openable)materialData).isOpen();
        }
        return false;
    }

    private boolean setBlockOpen(Block block, boolean open) {
        BlockData materialData = block.getBlockData();
        if (!ContainerProtectionImpl.isFunctionalOpenable(materialData)) {
            return false;
        }
        Openable openable = (Openable)materialData;
        if (openable.isOpen() == open) {
            return false;
        }
        openable.setOpen(open);
        block.setBlockData(materialData);
        return true;
    }

    @Override
    public void setOpen(boolean open, Protection.SoundCondition playSound) {
        boolean changed = false;
        Block aBlock = null;
        for (Block block : this.blocks) {
            changed |= this.setBlockOpen(block, open);
            aBlock = block;
        }
        if (aBlock == null) {
            return;
        }
        if (changed && playSound == Protection.SoundCondition.ALWAYS) {
            Sound sound = OpenBlockSound.get(aBlock.getType(), open);
            aBlock.getWorld().playSound(aBlock.getLocation(), sound, 1.0f, 0.7f);
        }
    }
}

