/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.blocklocker.impl.group;

import com.gmail.nossr50.api.PartyAPI;
import com.gmail.nossr50.mcMMO;
import java.util.Objects;
import nl.rutgerkok.blocklocker.group.GroupSystem;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public final class mcMMOGroupSystem
extends GroupSystem {
    public static boolean isAvailable() {
        try {
            JavaPlugin.getProvidingPlugin(mcMMO.class);
            return true;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    @Override
    public boolean isGroupLeader(Player player, String groupName) {
        if (!this.isInGroup(player, groupName)) {
            return false;
        }
        String leader = PartyAPI.getPartyLeader((String)groupName);
        return Objects.equals(player.getName(), leader);
    }

    @Override
    public boolean isInGroup(Player player, String groupName) {
        if (!PartyAPI.inParty((Player)player)) {
            return false;
        }
        String partyName = PartyAPI.getPartyName((Player)player);
        return partyName.equalsIgnoreCase(groupName);
    }

    @Override
    public boolean keepOnReload() {
        return false;
    }
}

