/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.blocklocker.impl.group;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import nl.rutgerkok.blocklocker.group.GroupSystem;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public final class TownyGroupSystem
extends GroupSystem {
    public static boolean isAvailable() {
        try {
            JavaPlugin.getProvidingPlugin(Towny.class);
            return true;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    @Override
    public boolean isGroupLeader(Player player, String groupName) {
        try {
            Resident resident = TownyUniverse.getInstance().getResident(player.getUniqueId());
            Town town = resident.getTown();
            if (town.getName().equalsIgnoreCase(groupName) && (town.isMayor(resident) || resident.hasTownRank("assistant"))) {
                return true;
            }
            Nation nation = town.getNation();
            return nation.getName().equalsIgnoreCase(groupName) && (nation.isKing(resident) || nation.hasAssistant(resident));
        }
        catch (Exception e) {
            if (e instanceof NotRegisteredException) {
                return false;
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isInGroup(Player player, String groupName) {
        try {
            Resident resident = TownyUniverse.getInstance().getResident(player.getName());
            Town town = resident.getTown();
            if (town.getName().equalsIgnoreCase(groupName)) {
                return true;
            }
            Nation nation = town.getNation();
            return nation.getName().equalsIgnoreCase(groupName);
        }
        catch (Exception e) {
            if (e instanceof NotRegisteredException) {
                return false;
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean keepOnReload() {
        return false;
    }
}

