/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.blocklocker.impl.event;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import nl.rutgerkok.blocklocker.AttackType;
import nl.rutgerkok.blocklocker.ProtectionSign;
import nl.rutgerkok.blocklocker.SearchMode;
import nl.rutgerkok.blocklocker.SignType;
import nl.rutgerkok.blocklocker.Translator;
import nl.rutgerkok.blocklocker.event.PlayerProtectionCreateEvent;
import nl.rutgerkok.blocklocker.impl.BlockLockerPluginImpl;
import nl.rutgerkok.blocklocker.impl.event.EventListener;
import nl.rutgerkok.blocklocker.location.IllegalLocationException;
import nl.rutgerkok.blocklocker.profile.PlayerProfile;
import nl.rutgerkok.blocklocker.profile.Profile;
import nl.rutgerkok.blocklocker.protection.Protection;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Lectern;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.block.data.type.WallSign;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerTakeLecternBookEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public final class InteractListener
extends EventListener {
    private static final Set<BlockFace> AUTOPLACE_BLOCK_FACES = ImmutableSet.of((Object)BlockFace.NORTH, (Object)BlockFace.EAST, (Object)BlockFace.SOUTH, (Object)BlockFace.WEST, (Object)BlockFace.UP);

    public InteractListener(BlockLockerPluginImpl plugin) {
        super(plugin);
    }

    private boolean allowedByBlockPlaceEvent(Block placedBlock, BlockState replacedBlockState, Block placedAgainst, EquipmentSlot placedUsingHand, Player player) {
        Material originalMaterial = placedBlock.getType();
        ItemStack itemInHand = placedUsingHand == EquipmentSlot.OFF_HAND ? player.getInventory().getItemInOffHand() : player.getInventory().getItemInMainHand();
        BlockPlaceEvent placeEvent = new BlockPlaceEvent(placedBlock, replacedBlockState, placedAgainst, itemInHand, player, true, placedUsingHand);
        Bukkit.getPluginManager().callEvent((Event)placeEvent);
        Material placedMaterial = placeEvent.getBlockPlaced().getType();
        return !placeEvent.isCancelled() && placedMaterial.equals((Object)originalMaterial);
    }

    private boolean canBuildInMode(GameMode gameMode) {
        if (gameMode == null) {
            return false;
        }
        return switch (gameMode) {
            default -> throw new MatchException(null, null);
            case GameMode.ADVENTURE, GameMode.SPECTATOR -> false;
            case GameMode.CREATIVE, GameMode.SURVIVAL -> true;
        };
    }

    private boolean isLecternOccupied(Lectern lectern) {
        return lectern.getInventory().contains(Material.WRITABLE_BOOK) || lectern.getInventory().contains(Material.WRITTEN_BOOK);
    }

    private boolean checkAllowed(Player player, Protection protection, boolean clickedSign, Block container) {
        PlayerProfile playerProfile = this.plugin.getProfileFactory().fromPlayer(player);
        boolean allowed = protection.isAllowed(playerProfile);
        if (!allowed && this.isExpired(protection)) {
            this.plugin.getTranslator().sendMessage((CommandSender)player, Translator.Translation.PROTECTION_EXPIRED);
            allowed = true;
        }
        if (!allowed && player.hasPermission("blocklocker.bypass")) {
            allowed = true;
            if (!clickedSign) {
                if (container.getType() == Material.LECTERN && this.isLecternOccupied((Lectern)container.getState())) {
                    return allowed;
                }
                String ownerName = protection.getOwnerDisplayName();
                this.plugin.getTranslator().sendMessage((CommandSender)player, Translator.Translation.PROTECTION_BYPASSED, ownerName);
            }
        }
        return allowed;
    }

    private Block getInventoryBlockOrNull(Inventory inventory) {
        Location location = inventory.getLocation();
        if (location == null) {
            return null;
        }
        return location.getBlock();
    }

    private org.bukkit.block.data.type.Sign getRotatedSignPost(Player player, Material signMaterial) {
        float rotation = player.getLocation().getYaw();
        if (rotation < 0.0f) {
            rotation += 360.0f;
        }
        org.bukkit.block.data.type.Sign materialData = (org.bukkit.block.data.type.Sign)signMaterial.createBlockData();
        materialData.setRotation(this.rotationToBlockFace(rotation));
        return materialData;
    }

    private Waterlogged getSignBlockData(BlockFace blockFace, Player player, Material signMaterial) {
        if (blockFace == BlockFace.UP) {
            return this.getRotatedSignPost(player, signMaterial);
        }
        WallSign wallSignData = (WallSign)this.toWallSign(signMaterial).createBlockData();
        wallSignData.setFacing(blockFace);
        return wallSignData;
    }

    private Optional<Material> getSignInHand(Player player, EquipmentSlot hand) {
        ItemStack item;
        PlayerInventory inventory = player.getInventory();
        ItemStack itemStack = item = hand == EquipmentSlot.OFF_HAND ? inventory.getItemInOffHand() : inventory.getItemInMainHand();
        if (this.isOfType(item, (Tag<Material>)Tag.SIGNS)) {
            return Optional.of(item.getType());
        }
        return Optional.empty();
    }

    private void handleAllowed(PlayerInteractEvent event, Protection protection, boolean clickedSign, boolean usedOffHand) {
        Block clickedBlock = event.getClickedBlock();
        Player player = event.getPlayer();
        PlayerProfile playerProfile = this.plugin.getProfileFactory().fromPlayer(player);
        boolean isOwner = protection.isOwner(playerProfile);
        if (clickedSign) {
            if (!isOwner && !player.hasPermission("blocklocker.admin") || usedOffHand || player.isSneaking()) {
                event.setCancelled(true);
            }
            return;
        }
        if (isOwner && this.tryPlaceSign(player, clickedBlock, event.getBlockFace(), event.getHand(), SignType.MORE_USERS)) {
            event.setCancelled(true);
            return;
        }
        boolean clickedMainBlock = this.plugin.getProtectionFinder().findProtection(clickedBlock, SearchMode.NO_SUPPORTING_BLOCKS).filter(p -> p.equals(protection)).isPresent();
        if (protection.canBeOpened() && !this.isSneakPlacing(player) && clickedMainBlock) {
            event.setCancelled(true);
            if (!usedOffHand) {
                if (protection.isOpen()) {
                    protection.setOpen(false, Protection.SoundCondition.AUTOMATIC);
                } else {
                    protection.setOpen(true, Protection.SoundCondition.AUTOMATIC);
                }
                this.scheduleClose(protection);
            }
        }
    }

    private void handleDisallowed(PlayerInteractEvent event, Protection protection, boolean clickedSign, boolean usedOffHand) {
        Block clickedBlock = event.getClickedBlock();
        Player player = event.getPlayer();
        Material heldBlock = player.getInventory().getItemInMainHand().getType();
        if (clickedBlock.getType() == Material.LECTERN) {
            if (heldBlock != Material.WRITABLE_BOOK && heldBlock != Material.WRITTEN_BOOK) {
                return;
            }
            if (this.isLecternOccupied((Lectern)clickedBlock.getState())) {
                return;
            }
        }
        event.setCancelled(true);
        if (usedOffHand) {
            return;
        }
        if (clickedSign) {
            this.plugin.getTranslator().sendMessage((CommandSender)player, Translator.Translation.PROTECTION_IS_CLAIMED_BY, protection.getOwnerDisplayName());
        } else {
            this.plugin.getTranslator().sendMessage((CommandSender)player, Translator.Translation.PROTECTION_NO_ACCESS, protection.getOwnerDisplayName());
        }
    }

    private boolean isNullOrAir(ItemStack stack) {
        return stack == null || stack.getType() == Material.AIR || stack.getAmount() == 0;
    }

    private boolean isOfType(ItemStack stackOrNull, Tag<Material> tag) {
        if (stackOrNull == null) {
            return false;
        }
        return tag.isTagged((Keyed)stackOrNull.getType());
    }

    private boolean isSneakPlacing(Player player) {
        if (!player.isSneaking()) {
            return false;
        }
        if (this.isNullOrAir(player.getInventory().getItemInMainHand())) {
            return false;
        }
        return !this.isNullOrAir(player.getInventory().getItemInOffHand());
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityInteract(EntityInteractEvent event) {
        if (!(event.getEntity() instanceof Villager)) {
            return;
        }
        if (this.plugin.getChestSettings().allowDestroyBy(AttackType.VILLAGER)) {
            return;
        }
        if (this.isProtected(event.getBlock())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryMoveItemEvent(InventoryMoveItemEvent event) {
        Block from = this.getInventoryBlockOrNull(event.getSource());
        if (from != null && this.isRedstoneDenied(from)) {
            event.setCancelled(true);
            return;
        }
        Block to = this.getInventoryBlockOrNull(event.getDestination());
        if (to != null && this.isRedstoneDenied(to)) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerTakeLectern(PlayerTakeLecternBookEvent event) {
        if (event == null) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getLectern().getBlock();
        Optional<Protection> protection = this.plugin.getProtectionFinder().findProtection(block);
        if (protection.isEmpty()) {
            return;
        }
        boolean allowed = this.checkAllowed(player, protection.get(), false, block);
        boolean innerCheck = protection.get().isAllowed(this.plugin.getProfileFactory().fromPlayer(player));
        if (!allowed) {
            event.setCancelled(true);
            this.plugin.getTranslator().sendMessage((CommandSender)player, Translator.Translation.PROTECTION_NO_ACCESS, protection.get().getOwnerDisplayName());
        } else if (!innerCheck && player.hasPermission("blocklocker.bypass")) {
            String ownerName = protection.get().getOwnerDisplayName();
            this.plugin.getTranslator().sendMessage((CommandSender)player, Translator.Translation.PROTECTION_BYPASSED, ownerName);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Material material = block.getType();
        boolean clickedSign = Tag.STANDING_SIGNS.isTagged((Keyed)material) || Tag.WALL_SIGNS.isTagged((Keyed)material);
        boolean usedOffHand = event.getHand() == EquipmentSlot.OFF_HAND;
        Optional<Protection> protection = this.plugin.getProtectionFinder().findProtection(block);
        if (protection.isEmpty()) {
            if (this.tryPlaceSign(event.getPlayer(), block, event.getBlockFace(), event.getHand(), SignType.PRIVATE)) {
                event.setCancelled(true);
            }
            return;
        }
        this.plugin.getProtectionUpdater().update(protection.get(), false);
        if (this.checkAllowed(player, protection.get(), clickedSign, block)) {
            this.handleAllowed(event, protection.get(), clickedSign, usedOffHand);
        } else {
            this.handleDisallowed(event, protection.get(), clickedSign, usedOffHand);
        }
    }

    private ItemStack removeOneItem(ItemStack item) {
        if (item.getAmount() > 1) {
            item.setAmount(item.getAmount() - 1);
            return item;
        }
        return null;
    }

    private void removeSingleSignFromHand(Player player) {
        if (player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        PlayerInventory inventory = player.getInventory();
        if (this.isOfType(inventory.getItemInMainHand(), (Tag<Material>)Tag.SIGNS)) {
            inventory.setItemInMainHand(this.removeOneItem(inventory.getItemInMainHand()));
        } else if (this.isOfType(inventory.getItemInOffHand(), (Tag<Material>)Tag.SIGNS)) {
            inventory.setItemInOffHand(this.removeOneItem(inventory.getItemInOffHand()));
        }
    }

    private BlockFace rotationToBlockFace(float rotation) {
        int intRotation = Math.round(rotation / 360.0f * 16.0f);
        byte dataValue = (byte)((intRotation + 8) % 16);
        switch (dataValue) {
            case 0: {
                return BlockFace.SOUTH;
            }
            case 1: {
                return BlockFace.SOUTH_SOUTH_WEST;
            }
            case 2: {
                return BlockFace.SOUTH_WEST;
            }
            case 3: {
                return BlockFace.WEST_SOUTH_WEST;
            }
            case 4: {
                return BlockFace.WEST;
            }
            case 5: {
                return BlockFace.WEST_NORTH_WEST;
            }
            case 6: {
                return BlockFace.NORTH_WEST;
            }
            case 7: {
                return BlockFace.NORTH_NORTH_WEST;
            }
            case 8: {
                return BlockFace.NORTH;
            }
            case 9: {
                return BlockFace.NORTH_NORTH_EAST;
            }
            case 10: {
                return BlockFace.NORTH_EAST;
            }
            case 11: {
                return BlockFace.EAST_NORTH_EAST;
            }
            case 12: {
                return BlockFace.EAST;
            }
            case 13: {
                return BlockFace.EAST_SOUTH_EAST;
            }
            case 14: {
                return BlockFace.SOUTH_EAST;
            }
            case 15: {
                return BlockFace.SOUTH_SOUTH_EAST;
            }
        }
        throw new RuntimeException("Couldn't handle rotation " + rotation);
    }

    private void scheduleClose(Protection protection) {
        if (!protection.isOpen()) {
            return;
        }
        int openSeconds = protection.getOpenSeconds();
        if (openSeconds == -1) {
            openSeconds = this.plugin.getChestSettings().getDefaultDoorOpenSeconds();
        }
        if (openSeconds <= 0) {
            return;
        }
        this.plugin.runLater(protection.getSomeProtectedBlock(), () -> protection.setOpen(false, Protection.SoundCondition.ALWAYS), openSeconds * 20);
    }

    private Material toWallSign(Material signMaterial) {
        return Material.valueOf((String)signMaterial.name().replace("_SIGN", "_WALL_SIGN"));
    }

    private boolean tryPlaceSign(Player player, Block block, BlockFace clickedSide, EquipmentSlot hand, SignType signType) {
        if (player.isSneaking() || !this.canBuildInMode(player.getGameMode())) {
            return false;
        }
        Optional<Material> optionalSignMaterial = this.getSignInHand(player, hand);
        if (!optionalSignMaterial.isPresent()) {
            return false;
        }
        Material signMaterial = optionalSignMaterial.get();
        if (!this.plugin.getProtectionFinder().isProtectable(block)) {
            return false;
        }
        if (!player.hasPermission("blocklocker.protect")) {
            return false;
        }
        if (!AUTOPLACE_BLOCK_FACES.contains(clickedSide)) {
            return false;
        }
        try {
            this.plugin.getLocationCheckers().checkLocationAndPermission(player, block);
        }
        catch (IllegalLocationException e) {
            return false;
        }
        Block signBlock = block.getRelative(clickedSide);
        boolean waterlogged = false;
        if (!signBlock.getType().isAir()) {
            if (signBlock.getType() != Material.WATER) {
                return false;
            }
            boolean bl = waterlogged = ((Levelled)signBlock.getBlockData()).getLevel() == 0;
        }
        if (this.plugin.callEvent(new PlayerProtectionCreateEvent(player, signBlock)).isCancelled()) {
            return false;
        }
        BlockState oldState = signBlock.getState();
        Waterlogged newBlockData = this.getSignBlockData(clickedSide, player, signMaterial);
        newBlockData.setWaterlogged(waterlogged);
        signBlock.setBlockData((BlockData)newBlockData);
        if (!this.allowedByBlockPlaceEvent(signBlock, oldState, block, hand, player)) {
            oldState.update(true);
            return false;
        }
        Sign sign = (Sign)signBlock.getState();
        Profile profile = signType.isMainSign() ? this.plugin.getProfileFactory().fromPlayer(player) : this.plugin.getProfileFactory().fromRedstone();
        ProtectionSign protectionSign = this.plugin.getProtectionFinder().newProtectionSign(sign, signType, profile);
        String[] newLines = this.plugin.getSignParser().getDisplayLines(protectionSign);
        SignChangeEvent signChangeEvent = new SignChangeEvent(sign.getBlock(), player, newLines, Side.FRONT);
        Bukkit.getPluginManager().callEvent((Event)signChangeEvent);
        if (sign.getBlock().getType() != sign.getType()) {
            this.removeSingleSignFromHand(player);
            return false;
        }
        if (signChangeEvent.isCancelled()) {
            oldState.update(true);
            return false;
        }
        SignSide frontSide = sign.getSide(Side.FRONT);
        for (int i = 0; i < newLines.length; ++i) {
            frontSide.setLine(i, newLines[i]);
        }
        sign.update();
        this.removeSingleSignFromHand(player);
        return true;
    }
}

