/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.blocklocker.impl.event;

import io.papermc.paper.event.entity.ItemTransportingEntityValidateTargetEvent;
import java.util.Optional;
import nl.rutgerkok.blocklocker.AttackType;
import nl.rutgerkok.blocklocker.ProtectionCache;
import nl.rutgerkok.blocklocker.SearchMode;
import nl.rutgerkok.blocklocker.impl.BlockLockerPluginImpl;
import nl.rutgerkok.blocklocker.impl.event.EventListener;
import nl.rutgerkok.blocklocker.profile.Profile;
import nl.rutgerkok.blocklocker.protection.Protection;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;

public final class GolemListener
extends EventListener {
    public GolemListener(BlockLockerPluginImpl plugin) {
        super(plugin);
    }

    @EventHandler
    public void onEntityContainerTarget(ItemTransportingEntityValidateTargetEvent event) {
        if (!event.isAllowed() || this.plugin.getChestSettings().allowDestroyBy(AttackType.GOLEM)) {
            return;
        }
        Block block = event.getBlock();
        ProtectionCache cache = this.plugin.getProtectionCache();
        ProtectionCache.CacheFlag cacheFlag = cache.getAllowed(block, ProtectionCache.CacheType.GOLEM);
        if (cacheFlag == ProtectionCache.CacheFlag.ALLOWED) {
            return;
        }
        if (cacheFlag == ProtectionCache.CacheFlag.NOT_ALLOWED) {
            event.setAllowed(false);
            return;
        }
        Optional<Protection> protection = this.plugin.getProtectionFinder().findProtection(block, SearchMode.MAIN_BLOCKS_ONLY);
        if (protection.isEmpty()) {
            cache.setAllowed(block, ProtectionCache.CacheType.GOLEM, false);
            return;
        }
        Profile golemProfile = this.plugin.getProfileFactory().fromGolem();
        boolean allowed = protection.get().isAllowed(golemProfile);
        cache.setAllowed(block, ProtectionCache.CacheType.GOLEM, allowed);
        if (!allowed) {
            event.setAllowed(false);
        }
    }
}

