/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.blocklocker.impl.event;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import nl.rutgerkok.blocklocker.Translator;
import nl.rutgerkok.blocklocker.impl.BlockLockerPluginImpl;
import nl.rutgerkok.blocklocker.impl.blockfinder.BlockFinder;
import nl.rutgerkok.blocklocker.impl.event.EventListener;
import nl.rutgerkok.blocklocker.location.IllegalLocationException;
import nl.rutgerkok.blocklocker.profile.PlayerProfile;
import nl.rutgerkok.blocklocker.protection.Protection;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.DoubleChest;
import org.bukkit.block.data.Directional;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.InventoryHolder;

public final class BlockPlaceListener
extends EventListener {
    private final Set<UUID> doNotSendChestHintPlayerIds = new HashSet<UUID>();

    public BlockPlaceListener(BlockLockerPluginImpl plugin) {
        super(plugin);
    }

    private Optional<Protection> getProtectionBySomeoneElse(Player player, Block block) {
        return this.plugin.getProtectionFinder().findProtection(block).filter(protection -> {
            PlayerProfile playerProfile = this.plugin.getProfileFactory().fromPlayer(player);
            return !protection.isOwner(playerProfile);
        });
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        Optional<Protection> interferingProtection = this.willInterfereWith(player, event.getBlockPlaced());
        if (interferingProtection.isPresent()) {
            if (!event.getPlayer().hasPermission("blocklocker.admin")) {
                this.plugin.getTranslator().sendMessage((CommandSender)player, Translator.Translation.PROTECTION_NO_ACCESS, interferingProtection.get().getOwnerDisplayName());
                event.setCancelled(true);
                return;
            }
            this.plugin.getTranslator().sendMessage((CommandSender)player, Translator.Translation.PROTECTION_BYPASSED, interferingProtection.get().getOwnerDisplayName());
            return;
        }
        if (event.getBlockPlaced().getType() != Material.CHEST) {
            return;
        }
        if (!player.hasPermission("blocklocker.protect")) {
            return;
        }
        try {
            this.plugin.getLocationCheckers().checkLocationAndPermission(player, event.getBlockPlaced());
        }
        catch (IllegalLocationException e) {
            return;
        }
        this.sendChestHint(player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendChestHint(Player player) {
        UUID playerId = player.getUniqueId();
        Set<UUID> set = this.doNotSendChestHintPlayerIds;
        synchronized (set) {
            if (this.doNotSendChestHintPlayerIds.contains(playerId)) {
                return;
            }
            this.plugin.getTranslator().sendMessage((CommandSender)player, Translator.Translation.PROTECTION_CHEST_HINT);
            this.doNotSendChestHintPlayerIds.add(playerId);
        }
        this.plugin.runLaterGlobally(() -> {
            Set<UUID> set = this.doNotSendChestHintPlayerIds;
            synchronized (set) {
                this.doNotSendChestHintPlayerIds.remove(playerId);
            }
        }, 2400);
    }

    private Optional<Protection> willInterfereWith(Player player, Block block) {
        if (this.plugin.getChestSettings().getConnectContainers()) {
            return this.willInterfereWithConnectedContainers(player, block);
        }
        return this.willInterfereWithStandard(player, block);
    }

    private Optional<Protection> willInterfereWithConnectedContainers(Player player, Block block) {
        block3: {
            block2: {
                if (!block.getType().equals((Object)Material.CHEST) && !block.getType().equals((Object)Material.TRAPPED_CHEST)) break block2;
                for (BlockFace searchFace : BlockFinder.NORTH_EAST_SOUTH_WEST_UP_DOWN) {
                    Optional<Protection> protectionBySomeoneElse;
                    Block nearBlock = block.getRelative(searchFace);
                    if (block.getType() != nearBlock.getType() || !(protectionBySomeoneElse = this.getProtectionBySomeoneElse(player, nearBlock)).isPresent()) continue;
                    return protectionBySomeoneElse;
                }
                break block3;
            }
            if (!Tag.DOORS.isTagged((Keyed)block.getType())) break block3;
            for (BlockFace searchFace : BlockFinder.CARDINAL_FACES) {
                Optional<Protection> protectionBySomeoneElse;
                Block nearBlock = block.getRelative(searchFace);
                if (block.getType() != nearBlock.getType() || !(protectionBySomeoneElse = this.getProtectionBySomeoneElse(player, nearBlock)).isPresent()) continue;
                return protectionBySomeoneElse;
            }
        }
        return Optional.empty();
    }

    private Optional<Protection> willInterfereWithStandard(Player player, Block block) {
        block4: {
            block3: {
                if (!block.getType().equals((Object)Material.CHEST) && !block.getType().equals((Object)Material.TRAPPED_CHEST)) break block3;
                if (player.isSneaking()) {
                    return Optional.empty();
                }
                for (BlockFace searchFace : BlockFinder.CARDINAL_FACES) {
                    Optional<Protection> protectionBySomeoneElse;
                    boolean areSiblings;
                    Block nearBlock = block.getRelative(searchFace);
                    if (block.getType() != nearBlock.getType()) continue;
                    BlockFace faceOfNearBlock = ((Directional)nearBlock.getBlockData()).getFacing();
                    BlockFace faceOfBlock = ((Directional)block.getBlockData()).getFacing();
                    boolean alreadyADoubleChest = ((InventoryHolder)nearBlock.getState()).getInventory().getHolder() instanceof DoubleChest;
                    if (alreadyADoubleChest) continue;
                    boolean bl = areSiblings = faceOfNearBlock == faceOfBlock && faceOfBlock != searchFace && faceOfBlock != searchFace.getOppositeFace();
                    if (!areSiblings || !(protectionBySomeoneElse = this.getProtectionBySomeoneElse(player, nearBlock)).isPresent()) continue;
                    return protectionBySomeoneElse;
                }
                break block4;
            }
            if (!Tag.DOORS.isTagged((Keyed)block.getType())) break block4;
            for (BlockFace searchFace : BlockFinder.CARDINAL_FACES) {
                Optional<Protection> protectionBySomeoneElse;
                Block nearBlock = block.getRelative(searchFace);
                if (block.getType() != nearBlock.getType() || !(protectionBySomeoneElse = this.getProtectionBySomeoneElse(player, nearBlock)).isPresent()) continue;
                return protectionBySomeoneElse;
            }
        }
        return Optional.empty();
    }
}

