/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.blocklocker.impl.event;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import nl.rutgerkok.blocklocker.BlockLockerPlugin;
import nl.rutgerkok.blocklocker.Translator;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabExecutor;

public final class BlockLockerCommand
implements TabExecutor {
    private final BlockLockerPlugin plugin;

    public BlockLockerCommand(BlockLockerPlugin plugin) {
        this.plugin = (BlockLockerPlugin)Preconditions.checkNotNull((Object)plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            return false;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            return this.reloadCommand(sender);
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 2) {
            return null;
        }
        if (args.length > 2) {
            return Collections.emptyList();
        }
        return Arrays.asList("2", "3", "4");
    }

    private boolean reloadCommand(CommandSender sender) {
        if (!sender.hasPermission("blocklocker.reload")) {
            this.plugin.getTranslator().sendMessage(sender, Translator.Translation.COMMAND_NO_PERMISSION);
            return true;
        }
        this.plugin.reload();
        this.plugin.getLogger().info(this.plugin.getTranslator().getWithoutColor(Translator.Translation.COMMAND_PLUGIN_RELOADED));
        if (!(sender instanceof ConsoleCommandSender)) {
            this.plugin.getTranslator().sendMessage(sender, Translator.Translation.COMMAND_PLUGIN_RELOADED);
        }
        return true;
    }
}

