/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.blocklocker.impl.event;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import nl.rutgerkok.blocklocker.AttackType;
import nl.rutgerkok.blocklocker.ProtectionSign;
import nl.rutgerkok.blocklocker.Translator;
import nl.rutgerkok.blocklocker.impl.BlockLockerPluginImpl;
import nl.rutgerkok.blocklocker.impl.event.EventListener;
import nl.rutgerkok.blocklocker.profile.PlayerProfile;
import nl.rutgerkok.blocklocker.protection.Protection;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.entity.EntityBreakDoorEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.world.StructureGrowEvent;

public class BlockDestroyListener
extends EventListener {
    public BlockDestroyListener(BlockLockerPluginImpl plugin) {
        super(plugin);
    }

    private Optional<ProtectionSign> asMainSign(Block block) {
        Material material = block.getType();
        if (!Tag.WALL_SIGNS.isTagged((Keyed)material) && !Tag.STANDING_SIGNS.isTagged((Keyed)material)) {
            return Optional.empty();
        }
        Optional<ProtectionSign> protectionSign = this.plugin.getSignParser().parseSign(block);
        if (!protectionSign.isPresent()) {
            return Optional.empty();
        }
        if (!protectionSign.get().getType().isMainSign()) {
            return Optional.empty();
        }
        return protectionSign;
    }

    private void destroyOtherSigns(ProtectionSign protectionSign, Protection protection) {
        for (ProtectionSign foundSign : protection.getSigns()) {
            if (foundSign.equals(protectionSign)) continue;
            foundSign.getLocation().getBlock().breakNaturally();
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Optional<ProtectionSign> mainSign;
        Block block = event.getBlock();
        Optional<Protection> protection = this.plugin.getProtectionFinder().findProtection(block);
        if (!protection.isPresent()) {
            return;
        }
        Player player = event.getPlayer();
        PlayerProfile profile = this.plugin.getProfileFactory().fromPlayer(player);
        if (!protection.get().isOwner(profile)) {
            if (player.hasPermission("blocklocker.admin")) {
                String ownerName = protection.get().getOwnerDisplayName();
                this.plugin.getTranslator().sendMessage((CommandSender)player, Translator.Translation.PROTECTION_BYPASSED, ownerName);
            } else if (this.isExpired(protection.get())) {
                this.plugin.getTranslator().sendMessage((CommandSender)player, Translator.Translation.PROTECTION_EXPIRED);
            } else {
                event.setCancelled(true);
                return;
            }
        }
        if ((mainSign = this.asMainSign(block)).isPresent()) {
            this.destroyOtherSigns(mainSign.get(), protection.get());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockBurnEvent(BlockBurnEvent event) {
        if (this.plugin.getChestSettings().allowDestroyBy(AttackType.FIRE)) {
            return;
        }
        if (this.isProtected(event.getBlock())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockExplodeEvent(BlockExplodeEvent event) {
        AttackType attackType = AttackType.BLOCK_EXPLOSION;
        if (this.plugin.getChestSettings().allowDestroyBy(attackType)) {
            return;
        }
        Iterator it = event.blockList().iterator();
        while (it.hasNext()) {
            Block block = (Block)it.next();
            if (!this.isProtected(block)) continue;
            it.remove();
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockPistonExtend(BlockPistonExtendEvent event) {
        if (this.plugin.getChestSettings().allowDestroyBy(AttackType.PISTON)) {
            return;
        }
        if (this.anyProtected(event.getBlocks())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockPistonRetract(BlockPistonRetractEvent event) {
        if (this.plugin.getChestSettings().allowDestroyBy(AttackType.PISTON)) {
            return;
        }
        if (event.isSticky() && this.anyProtected(event.getBlocks())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityChangeBlock(EntityChangeBlockEvent event) {
        AttackType attackType = AttackType.UNKNOWN;
        if (event instanceof EntityBreakDoorEvent) {
            attackType = AttackType.ZOMBIE;
        } else if (event.getEntity() instanceof Enderman) {
            attackType = AttackType.ENDERMAN;
        }
        if (this.plugin.getChestSettings().allowDestroyBy(attackType)) {
            return;
        }
        if (this.isProtected(event.getBlock())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityExplodeEvent(EntityExplodeEvent event) {
        AttackType attackType = AttackType.UNKNOWN;
        Entity attacker = event.getEntity();
        if (attacker instanceof TNTPrimed) {
            attackType = AttackType.TNT;
        } else if (attacker instanceof Creeper) {
            attackType = AttackType.CREEPER;
        } else if (attacker instanceof Fireball && ((Fireball)attacker).getShooter() instanceof Ghast) {
            attackType = AttackType.GHAST;
        }
        if (this.plugin.getChestSettings().allowDestroyBy(attackType)) {
            return;
        }
        Iterator it = event.blockList().iterator();
        while (it.hasNext()) {
            Block block = (Block)it.next();
            if (!this.isProtected(block)) continue;
            it.remove();
        }
    }

    @EventHandler
    public void onRedstone(BlockRedstoneEvent event) {
        if (event.getNewCurrent() == event.getOldCurrent()) {
            return;
        }
        if (this.isRedstoneDenied(event.getBlock())) {
            event.setNewCurrent(event.getOldCurrent());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onStructureGrow(StructureGrowEvent event) {
        if (this.plugin.getChestSettings().allowDestroyBy(AttackType.SAPLING)) {
            return;
        }
        List blocks = event.getBlocks();
        for (BlockState blockState : blocks) {
            if (blockState.getType() == Material.AIR || !this.isProtected(blockState.getBlock())) continue;
            event.setCancelled(true);
            return;
        }
    }
}

