/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.blocklocker.impl.blockfinder;

import java.util.ArrayList;
import java.util.List;
import nl.rutgerkok.blocklocker.SignParser;
import nl.rutgerkok.blocklocker.impl.blockfinder.BlockFinder;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

final class ConnectedContainersBlockFinder
extends BlockFinder {
    private static final int MAX_SEARCH_DISTANCE = 10;

    ConnectedContainersBlockFinder(SignParser parser) {
        super(parser);
    }

    @Override
    public List<Block> findContainerNeighbors(Block block) {
        Material containerMaterial = block.getType();
        ArrayList<Block> blocks = new ArrayList<Block>();
        blocks.add(block);
        this.searchVertical(containerMaterial, block, blocks);
        for (BlockFace face : CARDINAL_FACES) {
            Block atPosition = block.getRelative(face);
            for (int distance = 0; distance < 10 && atPosition.getType() == containerMaterial; ++distance) {
                blocks.add(atPosition);
                this.searchVertical(containerMaterial, atPosition, blocks);
                atPosition = atPosition.getRelative(face);
            }
        }
        BlockFace chestNeighborFace = this.getChestNeighborFaceOrNull(block);
        if (chestNeighborFace != null) {
            BlockFace[] searchDirections;
            Block chestNeighbor = block.getRelative(chestNeighborFace);
            for (BlockFace face : searchDirections = new BlockFace[]{this.turn90Degrees(chestNeighborFace), this.turn90Degrees(chestNeighborFace).getOppositeFace()}) {
                Block atPosition = chestNeighbor.getRelative(face);
                for (int distance = 0; distance < 10 && atPosition.getType() == containerMaterial; ++distance) {
                    blocks.add(atPosition);
                    this.searchVertical(containerMaterial, atPosition, blocks);
                    atPosition = atPosition.getRelative(face);
                }
            }
        }
        return blocks;
    }

    private void searchVertical(Material containerMaterial, Block startingBlock, List<Block> blocks) {
        for (BlockFace face : VERTICAL_FACES) {
            Block atPosition = startingBlock.getRelative(face);
            for (int distance = 0; distance < 10 && atPosition.getType() == containerMaterial; ++distance) {
                blocks.add(atPosition);
                atPosition = atPosition.getRelative(face);
            }
        }
    }
}

