/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.blocklocker.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import nl.rutgerkok.blocklocker.ChestSettings;
import nl.rutgerkok.blocklocker.ProtectionSign;
import nl.rutgerkok.blocklocker.SignParser;
import nl.rutgerkok.blocklocker.SignType;
import nl.rutgerkok.blocklocker.impl.NbtSecretSignEntry;
import nl.rutgerkok.blocklocker.impl.ProtectionSignImpl;
import nl.rutgerkok.blocklocker.impl.profile.ProfileFactoryImpl;
import nl.rutgerkok.blocklocker.profile.Profile;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

class SignParserImpl
implements SignParser {
    private static final NamespacedKey HEADER_KEY = NbtSecretSignEntry.key("header");
    private static final NamespacedKey[] PROFILE_KEYS = new NamespacedKey[]{NbtSecretSignEntry.key("profile_1"), NbtSecretSignEntry.key("profile_2"), NbtSecretSignEntry.key("profile_3"), NbtSecretSignEntry.key("profile_4"), NbtSecretSignEntry.key("profile_5"), NbtSecretSignEntry.key("profile_6")};
    private final ChestSettings chestSettings;
    private final ProfileFactoryImpl profileFactory;

    SignParserImpl(ChestSettings chestSettings, ProfileFactoryImpl profileFactory) {
        this.profileFactory = profileFactory;
        this.chestSettings = chestSettings;
    }

    @Override
    public String[] getDisplayLines(ProtectionSign sign) {
        List<Profile> profiles = sign.getProfiles();
        return new String[]{this.chestSettings.getFancyLocalizedHeader(sign.getType(), "?"), profiles.size() > 0 ? profiles.get(0).getDisplayName() : "", profiles.size() > 1 ? profiles.get(1).getDisplayName() : "", profiles.size() > 2 ? profiles.get(2).getDisplayName() : ""};
    }

    @Override
    public Optional<SignType> getSignType(Sign sign, Side side) {
        String header = sign.getSide(side).getLine(0);
        return Optional.ofNullable(this.getSignTypeOrNull(header));
    }

    @Override
    public Optional<SignType> getSignType(SignChangeEvent event) {
        return Optional.ofNullable(this.getSignTypeOrNull(event.getLine(0)));
    }

    private SignType getSignTypeOrNull(String header) {
        String trimmed = ChatColor.stripColor((String)header).trim();
        for (SignType type : SignType.values()) {
            if (!this.chestSettings.getSimpleLocalizedHeaders(type).stream().anyMatch(localizedHeader -> trimmed.equalsIgnoreCase((String)localizedHeader))) continue;
            return type;
        }
        return null;
    }

    @Override
    public boolean hasValidHeader(Sign sign) {
        return this.getSignType(sign, Side.FRONT).isPresent();
    }

    private Optional<ProtectionSign> parseAdvancedSign(Sign sign) {
        boolean headerMismatch;
        SignType type;
        PersistentDataContainer data = sign.getPersistentDataContainer();
        if (!data.has(HEADER_KEY, PersistentDataType.STRING)) {
            return Optional.empty();
        }
        boolean useBackside = this.getSignTypeOrNull(sign.getSide(Side.BACK).getLines()[0]) != null;
        String[] displayedNames = new String[useBackside ? 6 : 3];
        System.arraycopy(sign.getSide(Side.FRONT).getLines(), 1, displayedNames, 0, 3);
        if (useBackside) {
            System.arraycopy(sign.getSide(Side.BACK).getLines(), 1, displayedNames, 3, 3);
        }
        String signTypeString = (String)data.get(HEADER_KEY, PersistentDataType.STRING);
        try {
            type = SignType.valueOf(signTypeString);
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
        String header = sign.getSide(Side.FRONT).getLine(0);
        boolean bl = headerMismatch = !this.chestSettings.getFancyLocalizedHeader(type, header).equals(header);
        if (useBackside) {
            String backHeader = sign.getSide(Side.BACK).getLine(0);
            if (!this.chestSettings.getFancyLocalizedHeader(SignType.MORE_USERS, header).equals(backHeader)) {
                headerMismatch = true;
            }
        }
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        int i = 0;
        boolean signHadDataMismatch = false;
        for (NamespacedKey profileKey : PROFILE_KEYS) {
            Profile profile;
            NbtSecretSignEntry entry = (NbtSecretSignEntry)data.get(profileKey, NbtSecretSignEntry.TAG_TYPE);
            if (i >= 3 && !useBackside) {
                if (entry == null) break;
                signHadDataMismatch = true;
                break;
            }
            Profile profile2 = profile = entry == null ? this.profileFactory.emptyProfile() : this.profileFactory.fromSavedObject(entry).orElseGet(this.profileFactory::emptyProfile);
            if (profile.getDisplayName().equals(displayedNames[i])) {
                profiles.add(profile);
            } else {
                Profile newProfile = this.profileFactory.fromDisplayText(displayedNames[i]);
                profiles.add(newProfile);
                signHadDataMismatch = true;
            }
            ++i;
        }
        return Optional.of(new ProtectionSignImpl(sign.getLocation(), type, profiles, signHadDataMismatch || headerMismatch));
    }

    @Override
    public Optional<ProtectionSign> parseSign(Block sign) {
        Sign signState = (Sign)sign.getState();
        Optional<ProtectionSign> parsedSign = this.parseAdvancedSign(signState);
        if (parsedSign.isPresent()) {
            return parsedSign;
        }
        String[] frontLines = signState.getSide(Side.FRONT).getLines();
        String[] backLines = signState.getSide(Side.BACK).getLines();
        return this.parseSimpleSign(sign.getLocation(), frontLines, backLines);
    }

    private Optional<ProtectionSign> parseSimpleSign(Location location, String[] frontLines, String[] backLines) {
        String name;
        int i;
        SignType signType = this.getSignTypeOrNull(frontLines[0]);
        if (signType == null) {
            return Optional.empty();
        }
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        for (i = 1; i < frontLines.length; ++i) {
            name = frontLines[i].trim();
            profiles.add(this.profileFactory.fromDisplayText(name));
        }
        if (this.getSignTypeOrNull(backLines[0]) != null) {
            for (i = 1; i < backLines.length; ++i) {
                name = backLines[i].trim();
                profiles.add(this.profileFactory.fromDisplayText(name));
            }
        }
        ProtectionSignImpl protectionSignImpl = new ProtectionSignImpl(location, signType, profiles, true);
        return Optional.of(protectionSignImpl);
    }

    @Override
    public void saveSign(ProtectionSign sign) {
        Location signLocation = sign.getLocation();
        Block block = signLocation.getWorld().getBlockAt(signLocation);
        BlockState blockState = block.getState();
        if (!(blockState instanceof Sign)) {
            return;
        }
        List<Profile> profiles = sign.getProfiles();
        Sign signState = (Sign)blockState;
        SignSide frontSide = signState.getSide(Side.FRONT);
        SignSide backSide = signState.getSide(Side.BACK);
        frontSide.setLine(0, this.chestSettings.getFancyLocalizedHeader(sign.getType(), frontSide.getLine(0)));
        if (profiles.size() > 3) {
            backSide.setLine(0, this.chestSettings.getFancyLocalizedHeader(SignType.MORE_USERS, backSide.getLine(0)));
        }
        PersistentDataContainer data = signState.getPersistentDataContainer();
        data.set(HEADER_KEY, PersistentDataType.STRING, (Object)sign.getType().toString());
        int i = 0;
        for (Profile profile : profiles) {
            if (i < 3) {
                frontSide.setLine(i + 1, profile.getDisplayName());
            } else {
                backSide.setLine(i - 2, profile.getDisplayName());
            }
            NbtSecretSignEntry signEntry = new NbtSecretSignEntry(data.getAdapterContext().newPersistentDataContainer());
            profile.getSaveObject(signEntry);
            data.set(PROFILE_KEYS[i], NbtSecretSignEntry.TAG_TYPE, (Object)signEntry);
            ++i;
        }
        signState.update();
    }
}

