/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.blocklocker.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

final class SchedulerSupport {
    private static Method getRegionScheduler;
    private static Method getGlobalRegionScheduler;
    private static Method getAsyncScheduler;
    private static Class<?> globalRegionScheduler;
    private static Class<?> regionScheduler;
    private static Class<?> asyncScheduler;
    private static Method runDelayedOnGlobal;
    private static Method runDelayedOnRegion;
    private static Method runOnRegion;
    private static Method runAtFixedRateAsync;
    private static boolean folia;
    private final Plugin plugin;

    private static Object invoke(Object on, String name) {
        try {
            return on.getClass().getMethod(name, new Class[0]).invoke(on, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Cannot invoke instance." + name + "()", e);
        }
    }

    SchedulerSupport(Plugin plugin) {
        this.plugin = Objects.requireNonNull(plugin, "plugin");
    }

    public void runLater(Block block, Runnable runnable) {
        if (folia) {
            try {
                Object regionScheduler = getRegionScheduler.invoke((Object)this.plugin.getServer(), new Object[0]);
                Consumer<Object> consumer = task -> runnable.run();
                runOnRegion.invoke(regionScheduler, this.plugin, block.getLocation(), consumer);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.plugin.getServer().getScheduler().runTask(this.plugin, runnable);
        }
    }

    public void runLater(Block block, Runnable runnable, int ticks) {
        if (folia) {
            try {
                Object regionScheduler = getRegionScheduler.invoke((Object)this.plugin.getServer(), new Object[0]);
                Consumer<Object> consumer = task -> runnable.run();
                runDelayedOnRegion.invoke(regionScheduler, this.plugin, block.getWorld(), block.getX() >> 4, block.getZ() >> 4, consumer, ticks);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.plugin.getServer().getScheduler().runTaskLater(this.plugin, runnable, (long)ticks);
        }
    }

    void runLaterGlobally(Runnable runnable, int ticks) {
        if (folia) {
            try {
                Object globalRegionScheduler = getGlobalRegionScheduler.invoke((Object)this.plugin.getServer(), new Object[0]);
                Consumer<Object> consumer = task -> runnable.run();
                runDelayedOnGlobal.invoke(globalRegionScheduler, this.plugin, consumer, ticks);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.plugin.getServer().getScheduler().runTaskLater(this.plugin, runnable, (long)ticks);
        }
    }

    void runTimerAsync(Consumer<BukkitTask> task, long checkInterval) {
        if (folia) {
            try {
                Object asyncScheduler = getAsyncScheduler.invoke((Object)this.plugin.getServer(), new Object[0]);
                Consumer<Object> consumer = foliaTask -> task.accept(new BukkitTask(){

                    public void cancel() {
                        SchedulerSupport.invoke(foliaTask, "cancel");
                    }

                    public Plugin getOwner() {
                        return (Plugin)SchedulerSupport.invoke(foliaTask, "getOwningPlugin");
                    }

                    public int getTaskId() {
                        throw new UnsupportedOperationException();
                    }

                    public boolean isCancelled() {
                        return (Boolean)SchedulerSupport.invoke(foliaTask, "isCancelled");
                    }

                    public boolean isSync() {
                        return false;
                    }
                });
                runAtFixedRateAsync.invoke(asyncScheduler, new Object[]{this.plugin, consumer, 1, checkInterval * 50L, TimeUnit.MILLISECONDS});
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        } else {
            BukkitTask[] bukkitTask;
            bukkitTask = new BukkitTask[]{this.plugin.getServer().getScheduler().runTaskTimerAsynchronously(this.plugin, () -> task.accept(bukkitTask[0]), 1L, checkInterval)};
        }
    }

    static {
        try {
            getRegionScheduler = Server.class.getMethod("getRegionScheduler", new Class[0]);
            getGlobalRegionScheduler = Server.class.getMethod("getGlobalRegionScheduler", new Class[0]);
            getAsyncScheduler = Server.class.getMethod("getAsyncScheduler", new Class[0]);
            globalRegionScheduler = getGlobalRegionScheduler.getReturnType();
            regionScheduler = getRegionScheduler.getReturnType();
            asyncScheduler = getAsyncScheduler.getReturnType();
            runDelayedOnGlobal = globalRegionScheduler.getMethod("runDelayed", Plugin.class, Consumer.class, Long.TYPE);
            runDelayedOnRegion = regionScheduler.getMethod("runDelayed", Plugin.class, World.class, Integer.TYPE, Integer.TYPE, Consumer.class, Long.TYPE);
            runOnRegion = regionScheduler.getMethod("run", Plugin.class, Location.class, Consumer.class);
            runAtFixedRateAsync = asyncScheduler.getMethod("runAtFixedRate", Plugin.class, Consumer.class, Long.TYPE, Long.TYPE, TimeUnit.class);
            folia = true;
        }
        catch (NoSuchMethodException e) {
            folia = false;
        }
    }
}

