/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.blocklocker.impl;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import nl.rutgerkok.blocklocker.ChestSettings;
import nl.rutgerkok.blocklocker.ProtectionFinder;
import nl.rutgerkok.blocklocker.ProtectionSign;
import nl.rutgerkok.blocklocker.ProtectionType;
import nl.rutgerkok.blocklocker.SearchMode;
import nl.rutgerkok.blocklocker.SignType;
import nl.rutgerkok.blocklocker.impl.CompleteDoor;
import nl.rutgerkok.blocklocker.impl.ProtectionSignImpl;
import nl.rutgerkok.blocklocker.impl.blockfinder.BlockFinder;
import nl.rutgerkok.blocklocker.impl.protection.AttachedProtectionImpl;
import nl.rutgerkok.blocklocker.impl.protection.ContainerProtectionImpl;
import nl.rutgerkok.blocklocker.impl.protection.DoorProtectionImpl;
import nl.rutgerkok.blocklocker.profile.Profile;
import nl.rutgerkok.blocklocker.protection.Protection;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;

class ProtectionFinderImpl
implements ProtectionFinder {
    private final BlockFinder blockFinder;
    private final ChestSettings settings;

    ProtectionFinderImpl(BlockFinder lookup, ChestSettings settings) {
        this.blockFinder = lookup;
        this.settings = settings;
    }

    @Override
    public Optional<Protection> findExistingProtectionForNewSign(Block signBlock) {
        BlockState blockState = signBlock.getState();
        if (!(blockState instanceof Sign)) {
            return Optional.empty();
        }
        Optional<Block> protectionBlock = this.findProtectableForSign(signBlock);
        if (!protectionBlock.isPresent()) {
            return Optional.empty();
        }
        return this.findProtectionForBlock(protectionBlock.get(), SearchMode.NO_SUPPORTING_BLOCKS);
    }

    private Optional<Block> findProtectableForNonSignBlock(Block attachedBlock) {
        if (this.settings.canProtect(attachedBlock)) {
            return Optional.of(attachedBlock);
        }
        return this.findProtectableForSupportingBlock(attachedBlock);
    }

    private Optional<Block> findProtectableForSign(Block sign) {
        Block attachedBlock = this.blockFinder.findSupportingBlock(sign);
        return this.findProtectableForNonSignBlock(attachedBlock);
    }

    private Optional<Block> findProtectableForSupportingBlock(Block supportingBlock) {
        for (BlockFace doorFace : BlockFinder.NORTH_EAST_SOUTH_WEST_UP_DOWN) {
            Block blockUpDown = supportingBlock.getRelative(doorFace);
            if (this.settings.canProtect(ProtectionType.DOOR, blockUpDown)) {
                return Optional.of(blockUpDown);
            }
            if (!this.settings.canProtect(ProtectionType.ATTACHABLE, blockUpDown) || !this.blockFinder.findSupportingBlock(blockUpDown).equals((Object)supportingBlock)) continue;
            return Optional.of(blockUpDown);
        }
        return Optional.empty();
    }

    @Override
    public Optional<Protection> findProtection(Block block) {
        return this.findProtection(block, SearchMode.ALL);
    }

    @Override
    public Optional<Protection> findProtection(Block block, SearchMode searchMode) {
        Preconditions.checkNotNull((Object)block);
        Material blockMaterial = block.getType();
        if (searchMode.searchForSigns() && (Tag.WALL_SIGNS.isTagged((Keyed)blockMaterial) || Tag.STANDING_SIGNS.isTagged((Keyed)blockMaterial))) {
            return this.findProtectionForExistingSign(block);
        }
        return this.findProtectionForBlock(block, searchMode);
    }

    private Optional<Protection> findProtectionForBlock(Block block, SearchMode searchMode) {
        Optional<Block> protectionBlock;
        Optional<Protection> protection = this.findProtectionForProtectionBlock(block);
        if (protection.isPresent()) {
            return protection;
        }
        if (searchMode.searchForSupportingBlocks() && (protectionBlock = this.findProtectableForSupportingBlock(block)).isPresent()) {
            return this.findProtectionForProtectionBlock(protectionBlock.get());
        }
        return Optional.empty();
    }

    private Optional<Protection> findProtectionForExistingSign(Block sign) {
        Optional<ProtectionSign> parsed = this.blockFinder.getSignParser().parseSign(sign);
        if (!parsed.isPresent()) {
            return Optional.empty();
        }
        Optional<Block> protectionBlock = this.findProtectableForSign(sign);
        if (protectionBlock.isPresent()) {
            return this.findProtectionForProtectionBlock(protectionBlock.get(), parsed.get());
        }
        return Optional.empty();
    }

    private Optional<Protection> findProtectionForProtectionBlock(Block protectionBlock) {
        Optional<ProtectionType> protectionType = this.settings.getProtectionType(protectionBlock);
        if (!protectionType.isPresent()) {
            return Optional.empty();
        }
        switch (protectionType.get()) {
            case CONTAINER: {
                List<Block> blocks = this.blockFinder.findContainerNeighbors(protectionBlock);
                Collection<ProtectionSign> signs = this.blockFinder.findAttachedSigns(blocks);
                if (signs.isEmpty()) {
                    return Optional.empty();
                }
                return Optional.of(ContainerProtectionImpl.fromBlocksWithSigns(signs, blocks, this.blockFinder));
            }
            case DOOR: {
                CompleteDoor door = new CompleteDoor(protectionBlock);
                Collection<ProtectionSign> doorSigns = this.blockFinder.findAttachedSigns(door.getBlocksForSigns());
                if (doorSigns.isEmpty()) {
                    return Optional.empty();
                }
                return Optional.of(DoorProtectionImpl.fromDoorWithSigns(doorSigns, this.blockFinder, door));
            }
            case ATTACHABLE: {
                Collection<ProtectionSign> trapDoorSigns = this.blockFinder.findAttachedSigns(Arrays.asList(protectionBlock, this.blockFinder.findSupportingBlock(protectionBlock)));
                if (trapDoorSigns.isEmpty()) {
                    return Optional.empty();
                }
                return Optional.of(AttachedProtectionImpl.fromBlockWithSigns(trapDoorSigns, this.blockFinder, protectionBlock));
            }
        }
        throw new UnsupportedOperationException("Don't know how to handle protection type " + String.valueOf((Object)protectionType.get()));
    }

    private Optional<Protection> findProtectionForProtectionBlock(Block protectionBlock, ProtectionSign sign) {
        Optional<ProtectionType> protectionType = this.settings.getProtectionType(protectionBlock);
        if (!protectionType.isPresent()) {
            return Optional.empty();
        }
        switch (protectionType.get()) {
            case CONTAINER: {
                List<Block> blocks = this.blockFinder.findContainerNeighbors(protectionBlock);
                return Optional.of(ContainerProtectionImpl.fromBlocksWithSign(sign, blocks, this.blockFinder));
            }
            case DOOR: {
                CompleteDoor door = new CompleteDoor(protectionBlock);
                return Optional.of(DoorProtectionImpl.fromDoorWithSign(sign, this.blockFinder, door));
            }
            case ATTACHABLE: {
                return Optional.of(AttachedProtectionImpl.fromBlockWithSign(sign, this.blockFinder, protectionBlock));
            }
        }
        throw new UnsupportedOperationException("Don't know how to handle protection type " + String.valueOf((Object)protectionType.get()));
    }

    @Override
    public boolean isProtectable(Block block) {
        return this.findProtectableForNonSignBlock(block).isPresent();
    }

    @Override
    public boolean isSignNearbyProtectable(Block signBlock) {
        BlockState blockState = signBlock.getState();
        if (blockState instanceof Sign) {
            return this.findProtectableForSign(signBlock).isPresent();
        }
        return false;
    }

    @Override
    public ProtectionSign newProtectionSign(Sign sign, SignType signType, Profile onFirstLine) {
        return new ProtectionSignImpl(sign.getLocation(), signType, Collections.singletonList(onFirstLine), false);
    }
}

