/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.blocklocker.impl;

import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import nl.rutgerkok.blocklocker.SecretSignEntry;
import org.bukkit.NamespacedKey;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class NbtSecretSignEntry
implements SecretSignEntry {
    public static final PersistentDataType<PersistentDataContainer, NbtSecretSignEntry> TAG_TYPE = new SecretSignTagType();
    private static final WeakReference<Plugin> PLUGIN = new WeakReference<JavaPlugin>(JavaPlugin.getProvidingPlugin(NbtSecretSignEntry.class));
    private final PersistentDataContainer data;

    static NamespacedKey key(String name) {
        return new NamespacedKey((Plugin)PLUGIN.get(), name);
    }

    public NbtSecretSignEntry(PersistentDataContainer data) {
        this.data = Objects.requireNonNull(data);
    }

    @Override
    public Optional<Boolean> getBoolean(String key) {
        Byte result = (Byte)this.data.get(NbtSecretSignEntry.key(key), PersistentDataType.BYTE);
        if (result == null) {
            return Optional.empty();
        }
        if (result == 0) {
            return Optional.of(Boolean.FALSE);
        }
        return Optional.of(Boolean.TRUE);
    }

    @Override
    public OptionalInt getInteger(String key) {
        Integer integer = (Integer)this.data.get(NbtSecretSignEntry.key(key), PersistentDataType.INTEGER);
        if (integer == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(integer);
    }

    @Override
    public Optional<String> getString(String key) {
        return Optional.ofNullable((String)this.data.get(NbtSecretSignEntry.key(key), PersistentDataType.STRING));
    }

    @Override
    public Optional<UUID> getUniqueId(String key) {
        long[] array = (long[])this.data.get(NbtSecretSignEntry.key(key), PersistentDataType.LONG_ARRAY);
        if (array == null || array.length != 2) {
            return Optional.empty();
        }
        return Optional.of(new UUID(array[0], array[1]));
    }

    @Override
    public void setBoolean(String key, boolean value) {
        this.data.set(NbtSecretSignEntry.key(key), PersistentDataType.BYTE, (Object)(value ? (byte)1 : 0));
    }

    @Override
    public void setInteger(String key, int integer) {
        this.data.set(NbtSecretSignEntry.key(key), PersistentDataType.INTEGER, (Object)integer);
    }

    @Override
    public void setString(String key, String value) {
        this.data.set(NbtSecretSignEntry.key(key), PersistentDataType.STRING, (Object)value);
    }

    @Override
    public void setUniqueId(String key, UUID uuid) {
        long[] array = new long[]{uuid.getMostSignificantBits(), uuid.getLeastSignificantBits()};
        this.data.set(NbtSecretSignEntry.key(key), PersistentDataType.LONG_ARRAY, (Object)array);
    }

    private static class SecretSignTagType
    implements PersistentDataType<PersistentDataContainer, NbtSecretSignEntry> {
        private SecretSignTagType() {
        }

        public NbtSecretSignEntry fromPrimitive(PersistentDataContainer primitive, PersistentDataAdapterContext context) {
            return new NbtSecretSignEntry(primitive);
        }

        public Class<NbtSecretSignEntry> getComplexType() {
            return NbtSecretSignEntry.class;
        }

        public Class<PersistentDataContainer> getPrimitiveType() {
            return PersistentDataContainer.class;
        }

        public PersistentDataContainer toPrimitive(NbtSecretSignEntry complex, PersistentDataAdapterContext context) {
            return complex.data;
        }
    }
}

