/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.blocklocker.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import nl.rutgerkok.blocklocker.ProtectionCache;
import org.bukkit.block.Block;

final class HopperCacheImpl
implements ProtectionCache {
    private static final long EXPIRE_TIME_SECONDS = 10L;
    private final Cache<Block, Boolean> redstoneCache = CacheBuilder.newBuilder().initialCapacity(1000).maximumSize(5000L).expireAfterWrite(10L, TimeUnit.SECONDS).build();
    private final Cache<Block, Boolean> golemCache = CacheBuilder.newBuilder().initialCapacity(1000).maximumSize(5000L).expireAfterWrite(10L, TimeUnit.SECONDS).build();

    HopperCacheImpl() {
    }

    private Cache<Block, Boolean> getCache(ProtectionCache.CacheType cacheType) {
        return switch (cacheType) {
            default -> throw new MatchException(null, null);
            case ProtectionCache.CacheType.REDSTONE -> this.redstoneCache;
            case ProtectionCache.CacheType.GOLEM -> this.golemCache;
        };
    }

    @Override
    public ProtectionCache.CacheFlag getAllowed(Block block, ProtectionCache.CacheType cacheType) {
        Boolean isAllowed = (Boolean)this.getCache(cacheType).getIfPresent((Object)block);
        if (isAllowed == null) {
            return ProtectionCache.CacheFlag.MISS_CACHE;
        }
        if (isAllowed.booleanValue()) {
            return ProtectionCache.CacheFlag.ALLOWED;
        }
        return ProtectionCache.CacheFlag.NOT_ALLOWED;
    }

    @Override
    public void setAllowed(Block block, ProtectionCache.CacheType cacheType, boolean allowed) {
        this.getCache(cacheType).put((Object)block, (Object)allowed);
    }
}

