/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.blocklocker;

import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import nl.rutgerkok.blocklocker.BlockLockerPlugin;
import nl.rutgerkok.blocklocker.profile.PlayerProfile;
import nl.rutgerkok.blocklocker.profile.Profile;
import nl.rutgerkok.blocklocker.protection.Protection;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public final class BlockLockerAPIv2 {
    public static Optional<OfflinePlayer> getOwner(Block block) {
        Optional<Protection> protection = BlockLockerAPIv2.getPlugin().getProtectionFinder().findProtection(block);
        if (!protection.isPresent()) {
            return Optional.empty();
        }
        Profile owner = protection.get().getOwner().orElse(null);
        if (owner instanceof PlayerProfile) {
            Optional<UUID> uuid = ((PlayerProfile)owner).getUniqueId();
            if (uuid.isPresent()) {
                return Optional.of(Bukkit.getOfflinePlayer((UUID)uuid.get()));
            }
            BlockLockerAPIv2.getPlugin().getProtectionUpdater().update(protection.get(), false);
            return Optional.ofNullable(Bukkit.getOfflinePlayer((String)owner.getDisplayName()));
        }
        return Optional.empty();
    }

    public static Optional<String> getOwnerDisplayName(Block block) {
        Optional<Protection> protection = BlockLockerAPIv2.getPlugin().getProtectionFinder().findProtection(block);
        if (!protection.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(protection.get().getOwnerDisplayName());
    }

    public static final BlockLockerPlugin getPlugin() {
        return (BlockLockerPlugin)JavaPlugin.getProvidingPlugin(BlockLockerAPIv2.class);
    }

    public static boolean isAllowed(Player player, Block block, boolean allowBypass) {
        Optional<Date> expireDate;
        if (allowBypass && player.hasPermission("blocklocker.bypass")) {
            return true;
        }
        Optional<Protection> protection = BlockLockerAPIv2.getPlugin().getProtectionFinder().findProtection(block);
        if (!protection.isPresent()) {
            return true;
        }
        PlayerProfile playerProfile = BlockLockerAPIv2.getPlugin().getProfileFactory().fromPlayer(player);
        if (protection.get().isAllowed(playerProfile)) {
            return true;
        }
        return allowBypass && (expireDate = BlockLockerAPIv2.getPlugin().getChestSettings().getChestExpireDate()).isPresent() && protection.get().isExpired(expireDate.get());
    }

    public static boolean isOwner(Player player, Block block) {
        Optional<Protection> protection = BlockLockerAPIv2.getPlugin().getProtectionFinder().findProtection(block);
        if (!protection.isPresent()) {
            return false;
        }
        PlayerProfile playerProfile = BlockLockerAPIv2.getPlugin().getProfileFactory().fromPlayer(player);
        return protection.get().isOwner(playerProfile);
    }

    public static boolean isProtected(Block block) {
        return BlockLockerAPIv2.getPlugin().getProtectionFinder().findProtection(block).isPresent();
    }

    private BlockLockerAPIv2() {
    }
}

