/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest.util;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public final class BukkitExecutors {
    private final Plugin plugin;
    private final BukkitExecutor serverThreadExecutor = new BukkitExecutor(){

        @Override
        public void execute(Runnable task) {
            Server server = BukkitExecutors.this.plugin.getServer();
            if (server.isPrimaryThread()) {
                task.run();
            } else {
                server.getScheduler().runTask(BukkitExecutors.this.plugin, task);
            }
        }

        @Override
        public BukkitTask executeTimer(int ticks, Runnable runnable) {
            return BukkitExecutors.this.plugin.getServer().getScheduler().runTaskTimer(BukkitExecutors.this.plugin, runnable, (long)ticks, (long)ticks);
        }
    };
    private final BukkitExecutor workerThreadExecutor = new BukkitExecutor(){

        @Override
        public void execute(Runnable task) {
            Server server = BukkitExecutors.this.plugin.getServer();
            if (server.isPrimaryThread()) {
                server.getScheduler().runTaskAsynchronously(BukkitExecutors.this.plugin, task);
            } else {
                task.run();
            }
        }

        @Override
        public BukkitTask executeTimer(int ticks, Runnable runnable) {
            return BukkitExecutors.this.plugin.getServer().getScheduler().runTaskTimerAsynchronously(BukkitExecutors.this.plugin, runnable, (long)ticks, (long)ticks);
        }
    };

    public BukkitExecutors(Plugin plugin) {
        this.plugin = (Plugin)Preconditions.checkNotNull((Object)plugin, (Object)"plugin");
    }

    public BukkitExecutor serverThreadExecutor() {
        return this.serverThreadExecutor;
    }

    public BukkitExecutor workerThreadExecutor() {
        return this.workerThreadExecutor;
    }

    public static abstract class BukkitExecutor
    implements Executor {
        private BukkitExecutor() {
        }

        public abstract BukkitTask executeTimer(int var1, Runnable var2);

        public <T> ListenableFuture<T> submit(final Callable<T> task) {
            final SettableFuture future = SettableFuture.create();
            this.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        future.set(task.call());
                    }
                    catch (Exception e) {
                        future.setException((Throwable)e);
                    }
                }
            });
            return future;
        }
    }
}

