/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest.itemfilter;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

final class NameFilter
implements Predicate<ItemStack> {
    private final Pattern namePattern;
    private final boolean ignoreColors;

    NameFilter(Pattern name, boolean ignoreColors) {
        this.namePattern = (Pattern)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.ignoreColors = ignoreColors;
    }

    public boolean apply(ItemStack stack) {
        ItemMeta meta;
        if (stack.hasItemMeta() && (meta = stack.getItemMeta()).hasDisplayName()) {
            String displayName = stack.getItemMeta().getDisplayName();
            if (this.ignoreColors) {
                displayName = ChatColor.stripColor((String)displayName);
            }
            return this.namePattern.matcher(displayName).find();
        }
        return false;
    }
}

