/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest.itemfilter;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import nl.rutgerkok.betterenderchest.PluginLogger;
import nl.rutgerkok.betterenderchest.itemfilter.ItemTagFilter;
import nl.rutgerkok.betterenderchest.itemfilter.ItemTypeFilter;
import nl.rutgerkok.betterenderchest.itemfilter.LoreFilter;
import nl.rutgerkok.betterenderchest.itemfilter.NameFilter;
import nl.rutgerkok.betterenderchest.util.MaterialParser;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.inventory.ItemStack;

public final class ItemFilterReader
implements Function<Map<?, ?>, Predicate<ItemStack>> {
    private final PluginLogger logger;

    public ItemFilterReader(PluginLogger logger) {
        this.logger = (PluginLogger)Preconditions.checkNotNull((Object)logger);
    }

    public Predicate<ItemStack> apply(Map<?, ?> configSection) {
        Object andSection = configSection.get("and");
        if (andSection instanceof Map) {
            return Predicates.and(this.fromCheckFor(configSection), this.apply((Map)andSection));
        }
        return this.fromCheckFor(configSection);
    }

    private Predicate<ItemStack> fromCheckFor(Map<?, ?> configSection) {
        String key = this.toStringOrNull(configSection.get("check"));
        if (key == null) {
            this.logger.warning("Invalid item stack rule: no 'check' found");
            return Predicates.alwaysFalse();
        }
        if (key.equals("customName")) {
            return this.getRuleForName(configSection);
        }
        if (key.equals("lore")) {
            return this.getRuleForLore(configSection);
        }
        if (key.equals("itemType")) {
            return this.getRuleForItemType(configSection);
        }
        if (key.equals("itemTag")) {
            return this.getRuleForItemTag(configSection);
        }
        this.logger.warning("Invalid item rule: key '" + key + "' not recognized");
        return Predicates.alwaysFalse();
    }

    private Predicate<ItemStack> getRuleForItemTag(Map<?, ?> configSection) {
        NamespacedKey tagKey;
        String tagString = this.toStringOrNull(configSection.get("for"));
        if (tagString == null) {
            this.logger.warning("Invalid item rule: no 'for' found");
            return Predicates.alwaysFalse();
        }
        try {
            tagKey = MaterialParser.key(tagString);
        }
        catch (IllegalArgumentException e) {
            this.logger.warning("Invalid item rule: '" + tagString + "' is not a valid tag");
            return Predicates.alwaysFalse();
        }
        Tag tag = Bukkit.getTag((String)"blocks", (NamespacedKey)tagKey, Material.class);
        if (tag == null) {
            tag = Bukkit.getTag((String)"items", (NamespacedKey)tagKey, Material.class);
        }
        if (tag == null) {
            this.logger.warning("Invalid item rule: the tag '" + tagString + "' doesn't exist");
            return Predicates.alwaysFalse();
        }
        return new ItemTagFilter((Tag<Material>)tag);
    }

    private Predicate<ItemStack> getRuleForItemType(Map<?, ?> configSection) {
        String materialString = this.toStringOrNull(configSection.get("for"));
        if (materialString == null) {
            this.logger.warning("Invalid item rule: no 'for' found");
            return Predicates.alwaysFalse();
        }
        Material material = MaterialParser.matchMaterial(materialString);
        if (material == null) {
            this.logger.warning("Invalid item rule: '" + materialString + "' is not a valid material");
            return Predicates.alwaysFalse();
        }
        return new ItemTypeFilter(material);
    }

    private Predicate<ItemStack> getRuleForLore(Map<?, ?> configSection) {
        boolean ignoreColors = this.hasIgnoreFlag(configSection, "color");
        boolean ignoreCase = this.hasIgnoreFlag(configSection, "case");
        String value = this.toMultilineStringOrNull(configSection.get("for"));
        String valueRegex = this.toStringOrNull(configSection.get("forRegex"));
        if (value != null && valueRegex == null) {
            return new LoreFilter(this.patternFromLiteral(value, ignoreCase), ignoreColors);
        }
        if (value == null && valueRegex != null) {
            try {
                return new LoreFilter(this.patternFromRegex(valueRegex, ignoreCase), ignoreColors);
            }
            catch (PatternSyntaxException e) {
                this.logger.warning("Invalid regex in item rule: '" + e.getLocalizedMessage() + "' for regex " + valueRegex);
                return Predicates.alwaysFalse();
            }
        }
        if (value == null && valueRegex == null) {
            this.logger.warning("Invalid item rule: no 'for' found");
            return Predicates.alwaysFalse();
        }
        this.logger.warning("Invalid item rule: both 'for' and 'forRegex' found");
        return Predicates.alwaysFalse();
    }

    private Predicate<ItemStack> getRuleForName(Map<?, ?> configSection) {
        boolean ignoreColors = this.hasIgnoreFlag(configSection, "color");
        boolean ignoreCase = this.hasIgnoreFlag(configSection, "case");
        String value = this.toStringOrNull(configSection.get("for"));
        String valueRegex = this.toStringOrNull(configSection.get("forRegex"));
        if (value != null && valueRegex == null) {
            return new NameFilter(this.patternFromLiteral(value, ignoreCase), ignoreColors);
        }
        if (value == null && valueRegex != null) {
            try {
                return new NameFilter(this.patternFromRegex(valueRegex, ignoreCase), ignoreColors);
            }
            catch (PatternSyntaxException e) {
                this.logger.warning("Invalid regex in item rule: '" + e.getLocalizedMessage() + "' for regex " + valueRegex);
                return Predicates.alwaysFalse();
            }
        }
        if (value == null && valueRegex == null) {
            this.logger.warning("Invalid item rule: no 'for' found");
            return Predicates.alwaysFalse();
        }
        this.logger.warning("Invalid item rule: both 'for' and 'forRegex' found");
        return Predicates.alwaysFalse();
    }

    private boolean hasIgnoreFlag(Map<?, ?> configSection, String ignoreFlag) {
        Object ignoring = configSection.get("ignoring");
        if (ignoreFlag.equals(ignoring)) {
            return true;
        }
        if (ignoring instanceof Collection) {
            return ((Collection)ignoring).contains(ignoreFlag);
        }
        return false;
    }

    private Pattern patternFromLiteral(String literal, boolean ignoreCase) {
        literal = ChatColor.translateAlternateColorCodes((char)'&', (String)literal);
        int flags = 0;
        if (ignoreCase) {
            flags |= 2;
            flags |= 0x40;
        }
        return Pattern.compile("^" + Pattern.quote(literal) + "$", flags);
    }

    private Pattern patternFromRegex(String regex, boolean ignoreCase) {
        int flags = 0;
        if (ignoreCase) {
            flags |= 2;
            flags |= 0x40;
        }
        return Pattern.compile(regex, flags);
    }

    private String toMultilineStringOrNull(Object value) {
        if (value instanceof Collection) {
            return Joiner.on((char)'\n').join((Iterable)((Collection)value));
        }
        return null;
    }

    private String toStringOrNull(Object object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }
}

