/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest.io.mysql;

import org.bukkit.configuration.file.FileConfiguration;

public class DatabaseSettings {
    private final String databaseName;
    private final boolean enabled;
    private final String host;
    private final String password;
    private final int port;
    private final String username;
    private final boolean useUtf8;

    public DatabaseSettings(boolean enabled, String host, int port, String databaseName, String username, String password, boolean useUtf8) {
        this.enabled = enabled;
        this.host = host;
        this.port = port;
        this.databaseName = databaseName;
        this.username = username;
        this.password = password;
        this.useUtf8 = useUtf8;
    }

    public DatabaseSettings(FileConfiguration config) {
        this.useUtf8 = config.contains("Database.enabled") && !config.contains("Database.useUtf8") ? false : config.getBoolean("Database.useUtf8", true);
        this.enabled = config.getBoolean("Database.enabled", false);
        config.set("Database.enabled", (Object)this.enabled);
        this.host = config.getString("Database.host", "localhost");
        config.set("Database.host", (Object)this.host);
        this.port = config.getInt("Database.port", 3306);
        config.set("Database.port", (Object)this.port);
        this.databaseName = config.getString("Database.databaseName", "minecraft");
        config.set("Database.databaseName", (Object)this.databaseName);
        this.username = config.getString("Database.username", "root");
        config.set("Database.username", (Object)this.username);
        this.password = config.getString("Database.password", "");
        config.set("Database.password", (Object)this.password);
        config.set("Database.useUtf8", (Object)this.useUtf8);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getHost() {
        return this.host;
    }

    public String getPassword() {
        return this.password;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean useUtf8() {
        return this.useUtf8;
    }
}

