/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest.io.mysql;

import java.sql.SQLException;
import nl.rutgerkok.betterenderchest.BetterEnderChest;
import nl.rutgerkok.betterenderchest.WorldGroup;
import nl.rutgerkok.betterenderchest.io.BetterEnderCache;
import nl.rutgerkok.betterenderchest.io.DiscardingEnderCache;
import nl.rutgerkok.betterenderchest.io.SimpleEnderCache;
import nl.rutgerkok.betterenderchest.io.mysql.DatabaseSettings;
import nl.rutgerkok.betterenderchest.io.mysql.SQLChestLoader;
import nl.rutgerkok.betterenderchest.io.mysql.SQLChestSaver;
import nl.rutgerkok.betterenderchest.io.mysql.SQLHandler;
import nl.rutgerkok.betterenderchest.nms.NMSHandler;

public final class BetterEnderSQLCache
extends SimpleEnderCache {
    private final SQLHandler sqlHandler;

    public static final BetterEnderCache create(BetterEnderChest plugin) {
        DatabaseSettings settings = plugin.getDatabaseSettings();
        SQLHandler sqlHandler = null;
        try {
            sqlHandler = new SQLHandler(settings);
            for (WorldGroup group : plugin.getWorldGroupManager().getGroups()) {
                sqlHandler.createGroupTable(group);
            }
        }
        catch (SQLException e) {
            plugin.disableSaveAndLoad("Error creating a connection with database", e);
            return new DiscardingEnderCache(plugin);
        }
        NMSHandler nmsHandler = plugin.getNMSHandlers().getSelectedRegistration();
        return new BetterEnderSQLCache(plugin, sqlHandler, nmsHandler);
    }

    private BetterEnderSQLCache(BetterEnderChest plugin, SQLHandler sqlHandler, NMSHandler nmsHandler) {
        super(plugin, new SQLChestLoader(sqlHandler, nmsHandler), new SQLChestSaver(sqlHandler, nmsHandler));
        this.sqlHandler = sqlHandler;
    }

    @Override
    public void disable() {
        super.disable();
        try {
            this.sqlHandler.closeConnection();
        }
        catch (SQLException e) {
            this.plugin.severe("Failed to close connection with database", e);
        }
    }
}

