/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest.io;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.MapMaker;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import nl.rutgerkok.betterenderchest.BetterEnderChest;
import nl.rutgerkok.betterenderchest.BetterEnderChestPlugin;
import nl.rutgerkok.betterenderchest.BetterEnderInventoryHolder;
import nl.rutgerkok.betterenderchest.WorldGroup;
import nl.rutgerkok.betterenderchest.chestowner.ChestOwner;
import nl.rutgerkok.betterenderchest.exception.ChestNotFoundException;
import nl.rutgerkok.betterenderchest.io.BetterEnderCache;
import nl.rutgerkok.betterenderchest.io.ChestLoadLogic;
import nl.rutgerkok.betterenderchest.io.ChestLoader;
import nl.rutgerkok.betterenderchest.io.ChestSaver;
import nl.rutgerkok.betterenderchest.io.Consumer;
import nl.rutgerkok.betterenderchest.io.SaveEntry;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.Inventory;
import org.bukkit.scheduler.BukkitTask;

public class SimpleEnderCache
implements BetterEnderCache {
    private final BukkitTask autoSaveTask;
    private final ChestLoadLogic chestLoader;
    private final ChestSaver chestSaver;
    private final ConcurrentMap<ChestKey, Inventory> inventories;
    protected final BetterEnderChest plugin;

    public SimpleEnderCache(BetterEnderChest plugin, ChestLoader chestLoader, ChestSaver chestSaver) {
        this.plugin = (BetterEnderChest)Preconditions.checkNotNull((Object)plugin, (Object)"plugin");
        this.chestLoader = new ChestLoadLogic(plugin, chestLoader);
        this.chestSaver = (ChestSaver)Preconditions.checkNotNull((Object)chestSaver, (Object)"chestSaver");
        this.inventories = new MapMaker().concurrencyLevel(2).initialCapacity(16).makeMap();
        this.autoSaveTask = plugin.getExecutors().workerThreadExecutor().executeTimer(BetterEnderChestPlugin.AutoSave.autoSaveIntervalTicks, new Runnable(){

            @Override
            public void run() {
                SimpleEnderCache.this.cleanupCache();
            }
        });
    }

    private boolean canEvict(Inventory inventory) {
        return inventory.getViewers().isEmpty();
    }

    private final AsyncFunction<Throwable, Inventory> chestNotFoundToEmptyInventory(final ChestOwner chestOwner, final WorldGroup worldGroup) {
        return new AsyncFunction<Throwable, Inventory>(){

            public ListenableFuture<Inventory> apply(Throwable t) throws Exception {
                if (!(t instanceof ChestNotFoundException)) {
                    SimpleEnderCache.this.plugin.disableSaveAndLoad("Failed to load chest of " + chestOwner.getDisplayName(), t);
                }
                Inventory empty = SimpleEnderCache.this.plugin.getEmptyInventoryProvider().loadEmptyInventory(chestOwner, worldGroup);
                return Futures.immediateFuture((Object)empty);
            }
        };
    }

    private void cleanupCache() {
        for (Map.Entry entry : this.inventories.entrySet()) {
            Inventory inventory = (Inventory)entry.getValue();
            if (this.needsSave(inventory)) {
                this.scheduleSave(inventory);
                continue;
            }
            if (this.canEvict(inventory)) {
                this.unload(inventory);
                continue;
            }
            this.plugin.debug("Not unloading, but also not saving chest of " + ((ChestKey)entry.getKey()).chestOwner.getDisplayName() + " - no items changed, but chest is still in use. Viewers: " + this.viewersToString(inventory.getViewers()));
        }
    }

    @Override
    public void disable() {
        for (Inventory inventory : this.inventories.values()) {
            try {
                this.executeSaveProcedure(inventory);
            }
            catch (IOException e) {
                this.handleSaveError(inventory, e);
            }
        }
        this.inventories.clear();
        this.autoSaveTask.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSaveProcedure(Inventory inventory) throws IOException {
        BetterEnderInventoryHolder holder = BetterEnderInventoryHolder.of(inventory);
        Lock lock = holder.getSaveLock();
        lock.lock();
        try {
            if (!this.needsSave(inventory)) {
                this.plugin.debug("Cancelling save for inventory of " + holder.getChestOwner().getDisplayName() + " - it was just saved");
                return;
            }
            holder.markContentsAsSaved(inventory.getContents());
            this.plugin.debug("Saving chest of " + holder.getChestOwner().getDisplayName());
            this.chestSaver.saveChest(SaveEntry.copyOf(inventory));
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public ListenableFuture<Inventory> getInventory(ChestOwner chestOwner, WorldGroup worldGroup) {
        if (!this.plugin.canSaveAndLoad()) {
            Inventory emptyInventory = this.plugin.getEmptyInventoryProvider().loadEmptyInventory(chestOwner, worldGroup);
            return Futures.immediateFuture((Object)emptyInventory);
        }
        final ChestKey chestKey = new ChestKey(chestOwner, worldGroup);
        Inventory inventory = (Inventory)this.inventories.get(chestKey);
        if (inventory != null) {
            return Futures.immediateFuture((Object)inventory);
        }
        ListenableFuture<Inventory> loadingInventory = this.chestLoader.loadInventory(chestOwner, worldGroup);
        return Futures.transform(loadingInventory, (Function)new Function<Inventory, Inventory>(){

            public Inventory apply(Inventory newlyLoaded) {
                Inventory loadedEarlier = SimpleEnderCache.this.inventories.putIfAbsent(chestKey, newlyLoaded);
                return (Inventory)MoreObjects.firstNonNull((Object)loadedEarlier, (Object)newlyLoaded);
            }
        }, Runnable::run);
    }

    @Override
    public void getInventory(ChestOwner chestOwner, WorldGroup worldGroup, final Consumer<Inventory> callback) {
        ListenableFuture<Inventory> inventoryOrError = this.getInventory(chestOwner, worldGroup);
        final ListenableFuture inventory = Futures.catchingAsync(inventoryOrError, Throwable.class, this.chestNotFoundToEmptyInventory(chestOwner, worldGroup), Runnable::run);
        inventory.addListener(new Runnable(){

            @Override
            public void run() {
                try {
                    callback.consume((Inventory)inventory.get());
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e.getCause());
                }
            }
        }, (Executor)this.plugin.getExecutors().serverThreadExecutor());
    }

    private void handleSaveError(Inventory inventory, IOException exception) {
        BetterEnderInventoryHolder holder = BetterEnderInventoryHolder.of(inventory);
        this.plugin.disableSaveAndLoad("Failed to save chest of " + holder.getChestOwner().getDisplayName(), exception);
    }

    private boolean needsSave(Inventory inventory) {
        return BetterEnderInventoryHolder.of(inventory).hasUnsavedChanges(inventory.getContents());
    }

    private void scheduleSave(final Inventory inventory) {
        this.plugin.debug("Scheduling save for chest of " + BetterEnderInventoryHolder.of(inventory).getChestOwner().getDisplayName());
        this.plugin.getExecutors().workerThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    SimpleEnderCache.this.executeSaveProcedure(inventory);
                }
                catch (IOException e) {
                    SimpleEnderCache.this.handleSaveError(inventory, e);
                }
                if (SimpleEnderCache.this.canEvict(inventory)) {
                    SimpleEnderCache.this.unload(inventory);
                }
            }
        });
    }

    @Override
    public void setInventory(Inventory inventory) {
        BetterEnderInventoryHolder holder = BetterEnderInventoryHolder.of(inventory);
        ChestKey chestKey = new ChestKey(holder.getChestOwner(), holder.getWorldGroup());
        this.inventories.put(chestKey, inventory);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (ChestKey chestKey : this.inventories.keySet()) {
            builder.append(chestKey.worldGroup.getGroupName());
            builder.append('/');
            builder.append(chestKey.chestOwner.getDisplayName());
            builder.append(", ");
        }
        if (builder.length() == 0) {
            return "No inventories loaded.";
        }
        builder.delete(builder.length() - 2, builder.length());
        return builder.toString();
    }

    private void unload(Inventory inventory) {
        BetterEnderInventoryHolder holder = BetterEnderInventoryHolder.of(inventory);
        ChestKey chestKey = new ChestKey(holder.getChestOwner(), holder.getWorldGroup());
        this.plugin.debug("Unloading chest of " + chestKey.chestOwner.getDisplayName());
        this.inventories.remove(chestKey);
    }

    private String viewersToString(List<HumanEntity> viewers) {
        if (viewers.isEmpty()) {
            return "none";
        }
        StringBuilder builder = new StringBuilder();
        for (HumanEntity humanEntity : viewers) {
            builder.append(humanEntity.getName());
            builder.append(", ");
        }
        builder.delete(builder.length() - 2, builder.length());
        return builder.toString();
    }

    private static final class ChestKey {
        private final ChestOwner chestOwner;
        private final WorldGroup worldGroup;

        ChestKey(ChestOwner chestOwner, WorldGroup worldGroup) {
            this.worldGroup = (WorldGroup)Preconditions.checkNotNull((Object)worldGroup, (Object)"worldGroup");
            this.chestOwner = (ChestOwner)Preconditions.checkNotNull((Object)chestOwner, (Object)"chestOwner");
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ChestKey other = (ChestKey)obj;
            if (!this.chestOwner.equals(other.chestOwner)) {
                return false;
            }
            return this.worldGroup.equals(other.worldGroup);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = prime * result + this.chestOwner.hashCode();
            result = prime * result + this.worldGroup.hashCode();
            return result;
        }
    }
}

