/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest.io;

import java.util.Arrays;
import java.util.Objects;
import nl.rutgerkok.betterenderchest.BetterEnderInventoryHolder;
import nl.rutgerkok.betterenderchest.ChestRestrictions;
import nl.rutgerkok.betterenderchest.WorldGroup;
import nl.rutgerkok.betterenderchest.chestowner.ChestOwner;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public final class SaveEntry {
    private final ChestOwner chestOwner;
    private final ChestRestrictions chestRestrictions;
    private final WorldGroup group;
    private final ItemStack[] stacks;

    public static SaveEntry copyOf(Inventory inventory) {
        BetterEnderInventoryHolder holder = BetterEnderInventoryHolder.of(inventory);
        return new SaveEntry(holder.getChestOwner(), holder.getWorldGroup(), holder.getChestRestrictions(), inventory.getContents());
    }

    public SaveEntry(ChestOwner owner, WorldGroup group, ChestRestrictions restrictions, ItemStack ... stackView) {
        this.chestOwner = Objects.requireNonNull(owner, "owner");
        this.group = Objects.requireNonNull(group, "group");
        this.chestRestrictions = Objects.requireNonNull(restrictions, "restrictions");
        this.stacks = new ItemStack[stackView.length];
        for (int i = 0; i < this.stacks.length; ++i) {
            ItemStack original = stackView[i];
            if (original == null) continue;
            this.stacks[i] = stackView[i].clone();
        }
    }

    public ChestOwner getChestOwner() {
        return this.chestOwner;
    }

    public ChestRestrictions getChestRestrictions() {
        return this.chestRestrictions;
    }

    public String getDebugYaml() {
        YamlConfiguration config = new YamlConfiguration();
        config.set("stacks", Arrays.asList(this.stacks));
        config.set("owner", (Object)this.chestOwner.getDisplayName());
        config.set("world_group", (Object)this.group.getGroupName());
        return config.saveToString();
    }

    public ItemStack getItem(int slot) {
        return this.stacks[slot];
    }

    public int getSize() {
        return this.stacks.length;
    }

    public WorldGroup getWorldGroup() {
        return this.group;
    }
}

