/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest.importers;

import com.bergerkiller.bukkit.mw.MyWorlds;
import com.bergerkiller.bukkit.mw.WorldConfig;
import com.bergerkiller.bukkit.mw.WorldConfigStore;
import com.bergerkiller.bukkit.mw.WorldInventory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import nl.rutgerkok.betterenderchest.BetterEnderChest;
import nl.rutgerkok.betterenderchest.BetterEnderUtils;
import nl.rutgerkok.betterenderchest.WorldGroup;
import nl.rutgerkok.betterenderchest.chestowner.ChestOwner;
import nl.rutgerkok.betterenderchest.importers.InventoryImporter;
import nl.rutgerkok.betterenderchest.registry.Registration;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.inventory.Inventory;

public class MyWorldsImporter
extends InventoryImporter {
    @Override
    public String getName() {
        return "myworlds";
    }

    @Override
    public Registration.Priority getPriority() {
        return Registration.Priority.NORMAL;
    }

    @Override
    public Inventory importInventory(ChestOwner chestOwner, WorldGroup worldGroup, BetterEnderChest plugin) throws IOException {
        if (chestOwner.isSpecialChest()) {
            return null;
        }
        WorldConfig worldToGrabInventoryFrom = null;
        for (WorldInventory worldInventory : WorldInventory.getAll()) {
            if (!worldInventory.getSharedWorldName().equalsIgnoreCase(worldGroup.getGroupName())) continue;
            worldToGrabInventoryFrom = WorldConfigStore.get((String)worldInventory.getSharedWorldName());
            break;
        }
        if (worldToGrabInventoryFrom == null && Bukkit.getWorld((String)worldGroup.getGroupName()) != null) {
            worldToGrabInventoryFrom = WorldConfigStore.get((String)worldGroup.getGroupName());
        }
        if (worldToGrabInventoryFrom == null) {
            plugin.warning("Found no group with the name " + worldGroup.getGroupName() + " in MyWorlds, cannot import the Ender Chest of " + chestOwner.getDisplayName());
            return null;
        }
        File playerFolder = worldToGrabInventoryFrom.getPlayerFolder();
        File playerFile = new File(playerFolder, chestOwner.getSaveFileName() + ".dat");
        if (!playerFile.exists()) {
            return null;
        }
        Inventory inventory = plugin.getNMSHandlers().getSelectedRegistration().loadNBTInventoryFromFile(playerFile, chestOwner, worldGroup, "EnderItems");
        if (BetterEnderUtils.isInventoryEmpty(inventory)) {
            return null;
        }
        return inventory;
    }

    @Override
    public Iterable<WorldGroup> importWorldGroups(BetterEnderChest plugin) {
        if (MyWorlds.useWorldInventories) {
            WorldGroup worldGroup;
            Collection allGroups = WorldInventory.getAll();
            ArrayList<WorldGroup> worldGroups = new ArrayList<WorldGroup>(allGroups.size());
            HashSet usedWorlds = new HashSet();
            for (WorldInventory worldInventory : allGroups) {
                worldGroup = new WorldGroup(worldInventory.getSharedWorldName());
                worldGroup.setInventoryImporter(this);
                worldGroup.addWorlds(worldInventory.getWorlds());
                usedWorlds.addAll(worldInventory.getWorlds());
                worldGroups.add(worldGroup);
            }
            for (World world : Bukkit.getWorlds()) {
                if (usedWorlds.contains(world.getName())) continue;
                worldGroup = new WorldGroup(world.getName());
                worldGroup.setInventoryImporter(this);
                worldGroup.addWorld(world);
                worldGroups.add(worldGroup);
            }
            return worldGroups;
        }
        return plugin.getInventoryImporters().getRegistration("vanilla").importWorldGroups(plugin);
    }

    @Override
    public boolean isAvailable() {
        return Bukkit.getServer().getPluginManager().getPlugin("My Worlds") != null;
    }
}

