/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest.importers;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import nl.rutgerkok.betterenderchest.BetterEnderChest;
import nl.rutgerkok.betterenderchest.WorldGroup;
import nl.rutgerkok.betterenderchest.chestowner.ChestOwner;
import nl.rutgerkok.betterenderchest.exception.ChestNotFoundException;
import nl.rutgerkok.betterenderchest.importers.InventoryImporter;
import nl.rutgerkok.betterenderchest.registry.Registration;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.mvplugins.multiverse.inventories.MultiverseInventoriesApi;
import org.mvplugins.multiverse.inventories.profile.data.PlayerProfile;
import org.mvplugins.multiverse.inventories.profile.key.GlobalProfileKey;
import org.mvplugins.multiverse.inventories.profile.key.ProfileType;
import org.mvplugins.multiverse.inventories.profile.key.ProfileTypes;
import org.mvplugins.multiverse.inventories.share.Sharables;

public class MultiverseInventoriesImporter
extends InventoryImporter {
    @Override
    public String getName() {
        return "multiverse-inventories";
    }

    @Override
    public Registration.Priority getPriority() {
        return Registration.Priority.NORMAL;
    }

    @Override
    public ListenableFuture<Inventory> importInventoryAsync(ChestOwner chestOwner, WorldGroup worldGroup, BetterEnderChest plugin) {
        String groupName = worldGroup.getGroupName();
        OfflinePlayer offlinePlayer = chestOwner.getOfflinePlayer();
        if (offlinePlayer == null || chestOwner.isSpecialChest()) {
            return Futures.immediateFailedFuture((Throwable)new ChestNotFoundException(chestOwner, worldGroup));
        }
        MultiverseInventoriesApi multiverseInventories = MultiverseInventoriesApi.get();
        List multiverseInventoriesGroups = multiverseInventories.getWorldGroupManager().getGroups();
        org.mvplugins.multiverse.inventories.profile.group.WorldGroup group = multiverseInventoriesGroups.stream().filter(aGroup -> aGroup.getName().equalsIgnoreCase(groupName)).findAny().orElse(null);
        if (group == null) {
            plugin.warning("No matching Multiverse-Inventories group found for " + groupName + ". Cannot import " + chestOwner.getDisplayName() + ".");
            return Futures.immediateFailedFuture((Throwable)new ChestNotFoundException(chestOwner, worldGroup));
        }
        SettableFuture returnedInventory = SettableFuture.create();
        ((CompletableFuture)multiverseInventories.getProfileDataSource().getGlobalProfile(GlobalProfileKey.of((OfflinePlayer)offlinePlayer)).thenAcceptAsync(globalProfile -> {
            if (globalProfile == null) {
                plugin.debug("It seems that there is no data for " + chestOwner.getDisplayName() + ", so nothing can be imported.");
                returnedInventory.setException((Throwable)new ChestNotFoundException(chestOwner, worldGroup));
                return;
            }
            if (globalProfile.getLastWorld() == null) {
                plugin.debug("It seems that the world of " + chestOwner.getDisplayName() + " is null, so nothing can be imported.");
                returnedInventory.setException((Throwable)new ChestNotFoundException(chestOwner, worldGroup));
                return;
            }
            if (group.containsWorld(globalProfile.getLastWorld())) {
                returnedInventory.setFuture(plugin.getInventoryImporters().getRegistration("vanilla").importInventoryAsync(chestOwner, worldGroup, plugin));
            } else {
                ProfileType profileType = multiverseInventories.getInventoriesConfig().getEnableGamemodeShareHandling() ? ProfileTypes.forGameMode((GameMode)Bukkit.getDefaultGameMode()) : ProfileTypes.getDefault();
                try {
                    PlayerProfile playerData = (PlayerProfile)multiverseInventories.getWorldGroupManager().getGroup(groupName).getGroupProfileContainer().getPlayerData(profileType, offlinePlayer).get();
                    if (playerData == null) {
                        returnedInventory.setException((Throwable)new ChestNotFoundException(chestOwner, worldGroup));
                        return;
                    }
                    ItemStack[] stacks = (ItemStack[])playerData.get(Sharables.ENDER_CHEST);
                    if (stacks == null || stacks.length == 0) {
                        returnedInventory.setException((Throwable)new ChestNotFoundException(chestOwner, worldGroup));
                        return;
                    }
                    Inventory betterInventory = plugin.getEmptyInventoryProvider().loadEmptyInventory(chestOwner, worldGroup);
                    betterInventory.setContents(stacks);
                    returnedInventory.set((Object)betterInventory);
                }
                catch (InterruptedException e) {
                    returnedInventory.setException((Throwable)e);
                }
                catch (ExecutionException e) {
                    returnedInventory.setException(e.getCause());
                }
            }
        }, (Executor)plugin.getExecutors().workerThreadExecutor())).exceptionally(e -> {
            returnedInventory.setException(e);
            return null;
        });
        return returnedInventory;
    }

    @Override
    public Iterable<WorldGroup> importWorldGroups(BetterEnderChest plugin) {
        HashSet<WorldGroup> becGroups = new HashSet<WorldGroup>();
        MultiverseInventoriesApi multiverseInventories = MultiverseInventoriesApi.get();
        for (org.mvplugins.multiverse.inventories.profile.group.WorldGroup miGroup : multiverseInventories.getWorldGroupManager().getGroups()) {
            WorldGroup worldGroup = new WorldGroup(miGroup.getName());
            worldGroup.setInventoryImporter(this);
            worldGroup.addWorlds(miGroup.getWorlds());
            becGroups.add(worldGroup);
        }
        return becGroups;
    }

    @Override
    public boolean isAvailable() {
        return Bukkit.getServer().getPluginManager().getPlugin("Multiverse-Inventories") != null;
    }
}

