/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest.importers;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import nl.rutgerkok.betterenderchest.BetterEnderChest;
import nl.rutgerkok.betterenderchest.WorldGroup;
import nl.rutgerkok.betterenderchest.chestowner.ChestOwner;
import nl.rutgerkok.betterenderchest.importers.InventoryImporter;
import nl.rutgerkok.betterenderchest.registry.Registration;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.Inventory;
import uk.co.tggl.pluckerpluck.multiinv.MIYamlFiles;
import uk.co.tggl.pluckerpluck.multiinv.inventory.MIEnderchestInventory;
import uk.co.tggl.pluckerpluck.multiinv.inventory.MIItemStack;

public class MultiInvImporter
extends InventoryImporter {
    private WorldGroup createGroup(String groupName) {
        WorldGroup group = new WorldGroup(groupName);
        group.setInventoryImporter(this);
        return group;
    }

    private String getCaseCorrectGroup(String groupName) {
        for (Map.Entry entry : MIYamlFiles.getGroups().entrySet()) {
            String miGroupName = (String)entry.getValue();
            if (!miGroupName.equalsIgnoreCase(groupName)) continue;
            return miGroupName;
        }
        for (World world : Bukkit.getWorlds()) {
            if (!world.getName().equalsIgnoreCase(groupName)) continue;
            return world.getName();
        }
        return null;
    }

    @Override
    public String getName() {
        return "multiinv";
    }

    @Override
    public Registration.Priority getPriority() {
        return Registration.Priority.NORMAL;
    }

    @Override
    public Inventory importInventory(ChestOwner chestOwner, WorldGroup worldGroup, BetterEnderChest plugin) throws IOException {
        if (chestOwner.isSpecialChest()) {
            return null;
        }
        Inventory betterInventory = plugin.getEmptyInventoryProvider().loadEmptyInventory(chestOwner, worldGroup);
        String groupName = this.getCaseCorrectGroup(worldGroup.getGroupName());
        if (groupName == null) {
            plugin.warning("No matching MultiInv group found for " + worldGroup.getGroupName() + ". Cannot import " + chestOwner.getDisplayName() + ".");
            return null;
        }
        String gameModeName = null;
        gameModeName = !MIYamlFiles.separategamemodeinventories ? "SURVIVAL" : Bukkit.getDefaultGameMode().toString();
        MIEnderchestInventory multiInvEnderInventory = null;
        if (MIYamlFiles.usesql) {
            multiInvEnderInventory = MIYamlFiles.con.getEnderchestInventory(chestOwner.getOfflinePlayer(), groupName, gameModeName);
        } else {
            File multiInvDataFolder = Bukkit.getServer().getPluginManager().getPlugin("MultiInv").getDataFolder();
            File multiInvWorldsFolder = new File(multiInvDataFolder, "UUIDGroups");
            File multiInvFile = new File(multiInvWorldsFolder, groupName + "/" + chestOwner.getSaveFileName() + ".ec.yml");
            if (!multiInvFile.exists()) {
                return null;
            }
            YamlConfiguration playerFile = new YamlConfiguration();
            try {
                playerFile.load(multiInvFile);
            }
            catch (InvalidConfigurationException e) {
                throw new IOException("Cannot import from MultiInv: invalid chest file! (inventoryName: " + chestOwner.getDisplayName() + ", groupName:" + groupName);
            }
            String inventoryString = playerFile.getString(gameModeName, null);
            if (inventoryString == null || inventoryString == "") {
                return null;
            }
            multiInvEnderInventory = new MIEnderchestInventory(inventoryString);
        }
        if (multiInvEnderInventory == null) {
            return null;
        }
        MIItemStack[] inventoryContents = multiInvEnderInventory.getInventoryContents();
        if (inventoryContents == null) {
            return null;
        }
        for (int i = 0; i < inventoryContents.length && i < betterInventory.getSize(); ++i) {
            MIItemStack stack = inventoryContents[i];
            if (stack == null) continue;
            betterInventory.setItem(i, stack.getItemStack());
        }
        return betterInventory;
    }

    @Override
    public Iterable<WorldGroup> importWorldGroups(BetterEnderChest plugin) {
        HashMap<String, WorldGroup> becGroupsByName = new HashMap<String, WorldGroup>();
        for (Map.Entry miGroup : MIYamlFiles.getGroups().entrySet()) {
            String worldName = (String)miGroup.getKey();
            String groupName = ((String)miGroup.getValue()).toLowerCase();
            WorldGroup becGroup = (WorldGroup)becGroupsByName.get(groupName);
            if (becGroup == null) {
                becGroup = this.createGroup(groupName);
                becGroupsByName.put(groupName, becGroup);
            }
            becGroup.addWorld(worldName);
        }
        for (World world : Bukkit.getWorlds()) {
            if (this.isWorldInUse(world, becGroupsByName.values())) continue;
            WorldGroup becGroup = this.createGroup(world.getName());
            becGroup.addWorld(world);
            becGroupsByName.put(becGroup.getGroupName(), becGroup);
        }
        return becGroupsByName.values();
    }

    @Override
    public boolean isAvailable() {
        return Bukkit.getServer().getPluginManager().getPlugin("MultiInv") != null;
    }

    private boolean isWorldInUse(World world, Collection<WorldGroup> groups) {
        for (WorldGroup group : groups) {
            if (!group.isWorldInGroup(world)) continue;
            return true;
        }
        return false;
    }
}

