/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest.importers;

import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.concurrent.Callable;
import nl.rutgerkok.betterenderchest.BetterEnderChest;
import nl.rutgerkok.betterenderchest.WorldGroup;
import nl.rutgerkok.betterenderchest.chestowner.ChestOwner;
import nl.rutgerkok.betterenderchest.exception.ChestNotFoundException;
import nl.rutgerkok.betterenderchest.registry.Registration;
import org.bukkit.inventory.Inventory;

public abstract class InventoryImporter
implements Registration {
    protected Inventory importInventory(ChestOwner chestOwner, WorldGroup worldGroup, BetterEnderChest plugin) throws IOException {
        throw new UnsupportedOperationException("Either importInventory or importInventoryAsync must be overridden");
    }

    public ListenableFuture<Inventory> importInventoryAsync(final ChestOwner chestOwner, final WorldGroup worldGroup, final BetterEnderChest plugin) {
        return plugin.getExecutors().serverThreadExecutor().submit(new Callable<Inventory>(){

            @Override
            public Inventory call() throws Exception {
                Inventory inventory = InventoryImporter.this.importInventory(chestOwner, worldGroup, plugin);
                if (inventory == null) {
                    throw new ChestNotFoundException(chestOwner, worldGroup);
                }
                return inventory;
            }
        });
    }

    public abstract Iterable<WorldGroup> importWorldGroups(BetterEnderChest var1);
}

