/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest.importers;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashSet;
import nl.rutgerkok.betterenderchest.BetterEnderChest;
import nl.rutgerkok.betterenderchest.WorldGroup;
import nl.rutgerkok.betterenderchest.chestowner.ChestOwner;
import nl.rutgerkok.betterenderchest.importers.InventoryImporter;
import nl.rutgerkok.betterenderchest.io.mysql.SQLHandler;
import nl.rutgerkok.betterenderchest.registry.Registration;
import org.bukkit.Bukkit;
import org.bukkit.inventory.Inventory;

public class BetterEnderMySQLImporter
extends InventoryImporter {
    private boolean connectionFailed = false;
    private SQLHandler handler;

    @Override
    public String getName() {
        return "betterenderchest-mysqlnbt";
    }

    @Override
    public Registration.Priority getPriority() {
        return Registration.Priority.LOWEST;
    }

    @Override
    public Inventory importInventory(ChestOwner chestOwner, WorldGroup worldGroup, BetterEnderChest plugin) throws IOException {
        if (this.connectionFailed) {
            plugin.severe("Still cannot import inventories, check previous error messages. Conversion of " + chestOwner.getDisplayName() + " failed.");
            throw new IOException();
        }
        try {
            String rawJson;
            if (this.handler == null) {
                this.handler = new SQLHandler(plugin.getDatabaseSettings());
            }
            if ((rawJson = this.handler.loadChest(chestOwner, worldGroup)) != null) {
                return plugin.getNMSHandlers().getSelectedRegistration().loadNBTInventoryFromJson(rawJson, chestOwner, worldGroup);
            }
            return null;
        }
        catch (SQLException e) {
            this.connectionFailed = true;
            throw new IOException(e);
        }
    }

    @Override
    public Iterable<WorldGroup> importWorldGroups(BetterEnderChest plugin) {
        HashSet<WorldGroup> worldGroups = new HashSet<WorldGroup>();
        WorldGroup standardGroup = new WorldGroup("default");
        standardGroup.setInventoryImporter(this);
        standardGroup.addWorlds(Bukkit.getWorlds());
        worldGroups.add(standardGroup);
        return worldGroups;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }
}

