/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest.eventhandler;

import java.util.Iterator;
import java.util.Set;
import nl.rutgerkok.betterenderchest.BetterEnderChest;
import nl.rutgerkok.betterenderchest.BetterEnderInventoryHolder;
import nl.rutgerkok.betterenderchest.ImmutableInventory;
import nl.rutgerkok.betterenderchest.Translations;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class BetterEnderSlotsHandler
implements Listener {
    protected final BetterEnderChest plugin;

    public BetterEnderSlotsHandler(BetterEnderChest plugin) {
        this.plugin = plugin;
    }

    private boolean canPlaceStack(ItemStack cursor) {
        return this.plugin.isItemAllowedInChests(cursor);
    }

    protected void handleTakeOnlySlots(InventoryClickEvent event) {
        if (event.isShiftClick()) {
            this.handleTakeOnlySlotsShiftClick(event);
        } else {
            this.handleTakeOnlySlotsNormalClick(event);
        }
    }

    protected void handleTakeOnlySlotsNormalClick(InventoryClickEvent event) {
        ItemStack onHotbar;
        boolean invalidStack;
        Inventory inventory = event.getInventory();
        BetterEnderInventoryHolder holder = BetterEnderInventoryHolder.of(inventory);
        boolean cursorOutsideChest = event.getSlot() != event.getRawSlot() || event.getSlotType().equals((Object)InventoryType.SlotType.OUTSIDE);
        if (!this.isAddingItemToChest(event.getAction(), !cursorOutsideChest)) {
            return;
        }
        boolean bl = invalidStack = event.getCursor() != null && !this.canPlaceStack(event.getCursor());
        if (event.getHotbarButton() != -1 && (onHotbar = event.getWhoClicked().getInventory().getItem(event.getHotbarButton())) != null) {
            invalidStack |= !this.canPlaceStack(onHotbar);
        }
        int slotFromBottomRight = inventory.getSize() - event.getSlot();
        if (invalidStack || this.isInDisabledSlot(slotFromBottomRight, holder)) {
            this.updateInventoryLater(event.getWhoClicked());
            event.setCancelled(true);
            if (invalidStack) {
                this.sendInvalidItemMessage(event.getWhoClicked());
            }
        }
    }

    protected void handleTakeOnlySlotsShiftClick(InventoryClickEvent event) {
        ItemStack inSlot;
        int i;
        Inventory inventory = event.getInventory();
        BetterEnderInventoryHolder holder = (BetterEnderInventoryHolder)inventory.getHolder();
        if (event.getSlot() == event.getRawSlot()) {
            return;
        }
        if (this.isNullOrAir(event.getCurrentItem())) {
            return;
        }
        event.setCancelled(true);
        ItemStack adding = event.getCurrentItem();
        if (!this.canPlaceStack(adding)) {
            this.sendInvalidItemMessage(event.getWhoClicked());
            return;
        }
        int useableSlotsCount = inventory.getSize() - holder.getTakeOnlySlots();
        for (i = 0; i < useableSlotsCount; ++i) {
            inSlot = inventory.getItem(i);
            if (inSlot == null || !inSlot.isSimilar(adding)) continue;
            int itemsToAdd = Math.min(inventory.getMaxStackSize(), inSlot.getMaxStackSize()) - inSlot.getAmount();
            itemsToAdd = Math.max(itemsToAdd, 0);
            itemsToAdd = Math.min(adding.getAmount(), itemsToAdd);
            if (itemsToAdd > 0) {
                inSlot.setAmount(inSlot.getAmount() + itemsToAdd);
                inventory.setItem(i, inSlot);
            }
            if (itemsToAdd >= adding.getAmount()) {
                event.setCurrentItem(new ItemStack(Material.AIR, 0));
                return;
            }
            adding.setAmount(adding.getAmount() - itemsToAdd);
        }
        for (i = 0; i < useableSlotsCount; ++i) {
            inSlot = inventory.getItem(i);
            if (inSlot != null && !inSlot.getType().equals((Object)Material.AIR)) continue;
            inventory.setItem(i, adding);
            event.setCurrentItem(new ItemStack(Material.AIR, 0));
            return;
        }
        event.setCurrentItem(adding);
    }

    private boolean isAddingItemToChest(InventoryAction action, boolean cursorInChest) {
        switch (action) {
            case CLONE_STACK: {
                return cursorInChest;
            }
            case COLLECT_TO_CURSOR: {
                return false;
            }
            case DROP_ALL_CURSOR: {
                return false;
            }
            case DROP_ALL_SLOT: {
                return false;
            }
            case DROP_ONE_CURSOR: {
                return false;
            }
            case DROP_ONE_SLOT: {
                return false;
            }
            case HOTBAR_MOVE_AND_READD: {
                return true;
            }
            case HOTBAR_SWAP: {
                return true;
            }
            case MOVE_TO_OTHER_INVENTORY: {
                return cursorInChest;
            }
            case NOTHING: {
                return false;
            }
            case PICKUP_ALL: {
                return false;
            }
            case PICKUP_HALF: {
                return false;
            }
            case PICKUP_ONE: {
                return false;
            }
            case PICKUP_SOME: {
                return false;
            }
            case PLACE_ALL: {
                return cursorInChest;
            }
            case PLACE_ONE: {
                return cursorInChest;
            }
            case PLACE_SOME: {
                return cursorInChest;
            }
            case SWAP_WITH_CURSOR: {
                return true;
            }
            case UNKNOWN: {
                return true;
            }
        }
        return true;
    }

    private boolean isInDisabledSlot(int slotFromBottomRight, BetterEnderInventoryHolder holder) {
        return slotFromBottomRight <= holder.getTakeOnlySlots() && slotFromBottomRight > 0;
    }

    private boolean isNullOrAir(ItemStack stack) {
        return stack == null || stack.getType() == Material.AIR;
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        InventoryHolder inventoryHolder = event.getInventory().getHolder();
        if (inventoryHolder instanceof BetterEnderInventoryHolder) {
            this.handleTakeOnlySlots(event);
            return;
        }
        if (inventoryHolder instanceof ImmutableInventory) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryDrag(InventoryDragEvent event) {
        Inventory inventory = event.getInventory();
        if (!(inventory.getHolder() instanceof BetterEnderInventoryHolder)) {
            return;
        }
        if (this.isNullOrAir(event.getOldCursor())) {
            return;
        }
        BetterEnderInventoryHolder holder = BetterEnderInventoryHolder.of(inventory);
        boolean canPlaceInChest = this.canPlaceStack(event.getOldCursor());
        if (canPlaceInChest && holder.getTakeOnlySlots() == 0) {
            return;
        }
        Set allSlots = event.getRawSlots();
        Iterator iterator = allSlots.iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            if (slot != event.getView().convertSlot(slot)) continue;
            int slotFromBottomRight = event.getView().getTopInventory().getSize() - slot;
            if (canPlaceInChest && !this.isInDisabledSlot(slotFromBottomRight, holder)) continue;
            event.setCancelled(true);
            if (!canPlaceInChest) {
                this.sendInvalidItemMessage(event.getWhoClicked());
            }
            return;
        }
    }

    private void sendInvalidItemMessage(HumanEntity humanEntity) {
        String message = Translations.ITEM_NOT_ALLOWED.toString();
        if (message.length() > 0) {
            humanEntity.sendMessage(String.valueOf(ChatColor.YELLOW) + message);
        }
    }

    private void updateInventoryLater(final HumanEntity humanEntity) {
        if (!(humanEntity instanceof HumanEntity)) {
            return;
        }
        Bukkit.getScheduler().runTask(this.plugin.getPlugin(), new Runnable(){

            @Override
            public void run() {
                ((Player)humanEntity).updateInventory();
            }
        });
    }
}

