/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest.eventhandler;

import com.google.common.base.Preconditions;
import java.util.List;
import nl.rutgerkok.betterenderchest.BetterEnderChest;
import nl.rutgerkok.betterenderchest.BetterEnderChestPlugin;
import nl.rutgerkok.betterenderchest.BetterEnderInventoryHolder;
import nl.rutgerkok.betterenderchest.BetterEnderUtils;
import nl.rutgerkok.betterenderchest.ChestOpener;
import nl.rutgerkok.betterenderchest.Translations;
import nl.rutgerkok.betterenderchest.chestowner.ChestOwner;
import nl.rutgerkok.betterenderchest.exception.ChestProtectedException;
import nl.rutgerkok.betterenderchest.exception.NoPermissionException;
import nl.rutgerkok.betterenderchest.io.BetterEnderCache;
import nl.rutgerkok.betterenderchest.io.Consumer;
import nl.rutgerkok.betterenderchest.nms.NMSHandler;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;

public class BetterEnderEventHandler
implements Listener {
    private BetterEnderCache chests;
    private BetterEnderChest plugin;

    public BetterEnderEventHandler(BetterEnderChest plugin) {
        this.plugin = plugin;
        this.chests = plugin.getChestCache();
    }

    private Player getVanillaEnderChestOwner(Inventory inventory, Player guess) {
        Preconditions.checkArgument((inventory.getType() == InventoryType.ENDER_CHEST ? 1 : 0) != 0, (Object)"inventoryType must be ENDER_CHEST");
        if (inventory.equals((Object)guess.getEnderChest())) {
            return guess;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!inventory.equals((Object)player.getEnderChest())) continue;
            return player;
        }
        return guess;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        Player player = event.getPlayer();
        if (!block.getType().equals((Object)this.plugin.getChestMaterial())) {
            return;
        }
        if (!player.hasPermission("betterenderchest.user.destroy")) {
            event.setCancelled(true);
            player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(Translations.NO_PERMISSION));
            return;
        }
        this.plugin.getChestDropForPlayer(player).drop(event, this.plugin);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (event.getBlock().getType() != this.plugin.getChestMaterial()) {
            return;
        }
        Player player = event.getPlayer();
        if (!player.hasPermission("betterenderchest.user.place")) {
            event.setCancelled(true);
            player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(Translations.NO_PERMISSION));
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        if (event.getInventory().getHolder() instanceof BetterEnderInventoryHolder) {
            Location lastOpened = BetterEnderUtils.getLastEnderChestOpeningLocation(player);
            if (lastOpened != null) {
                NMSHandler nmsHandler = this.plugin.getNMSHandlers().getSelectedRegistration();
                if (nmsHandler != null) {
                    nmsHandler.closeEnderChest(lastOpened, player);
                }
                BetterEnderUtils.setLastEnderChestOpeningLocation(player, null, this.plugin);
            }
            BetterEnderUtils.dropItemsInDisabledSlots(event.getInventory(), player, this.plugin);
            BetterEnderInventoryHolder holder = (BetterEnderInventoryHolder)event.getInventory().getHolder();
            if (holder.getChestOwner().isPublicChest()) {
                if (!Translations.PUBLIC_CHEST_CLOSE_MESSAGE.isEmpty()) {
                    player.sendMessage(Translations.PUBLIC_CHEST_CLOSE_MESSAGE.toString());
                }
            } else if (holder.getChestOwner().isDefaultChest()) {
                player.sendMessage(Translations.EVENT_HANDLER_DEFAULT_EDITET.toString());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        final Player player = (Player)event.getPlayer();
        if (this.plugin.getCompatibilityMode() && event.getInventory().getType() == InventoryType.ENDER_CHEST) {
            ChestOwner chestOwner = null;
            event.setCancelled(true);
            if (BetterEnderChestPlugin.PublicChest.openOnOpeningUnprotectedChest) {
                if (!player.hasPermission("betterenderchest.user.open.publicchest")) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(Translations.NO_PERMISSION));
                    return;
                }
                chestOwner = this.plugin.getChestOwners().publicChest();
            } else {
                if (!player.hasPermission("betterenderchest.user.open.privatechest")) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(Translations.NO_PERMISSION));
                    return;
                }
                Player owner = this.getVanillaEnderChestOwner(event.getInventory(), player);
                chestOwner = this.plugin.getChestOwners().playerChest(owner);
            }
            this.chests.getInventory(chestOwner, this.plugin.getWorldGroupManager().getGroupByWorld(player.getWorld()), new Consumer<Inventory>(){

                @Override
                public void consume(Inventory inventory) {
                    player.openInventory(inventory);
                }
            });
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            return;
        }
        Block block = event.getClickedBlock();
        Player player = event.getPlayer();
        if (block.getType() != this.plugin.getChestMaterial()) {
            return;
        }
        if (player.isSneaking() && event.getItem() != null && !event.getItem().getType().equals((Object)Material.AIR)) {
            return;
        }
        event.setCancelled(true);
        if (!this.plugin.canSaveAndLoad()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + Translations.ENDER_CHESTS_DISABLED.toString());
            this.plugin.printSaveAndLoadError();
            return;
        }
        ChestOpener chestOpener = this.plugin.getChestOpener();
        try {
            chestOpener.getBlockInventory(player, block, chestOpener.showAnimatedInventory(player, block));
        }
        catch (NoPermissionException e) {
            player.sendMessage(String.valueOf(ChatColor.RED) + Translations.NO_PERMISSION.toString());
        }
        catch (ChestProtectedException e) {
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPrepareCraftItem(PrepareItemCraftEvent event) {
        if (event.getRecipe() == null || event.getRecipe().getResult() == null) {
            return;
        }
        if (event.getRecipe().getResult().getType() != this.plugin.getChestMaterial()) {
            return;
        }
        List viewers = event.getViewers();
        if (viewers == null || viewers.size() == 0 || !(viewers.get(0) instanceof Player)) {
            return;
        }
        Player player = (Player)event.getViewers().get(0);
        if (!player.hasPermission("betterenderchest.user.craft")) {
            event.getInventory().setResult(null);
        }
    }
}

