/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest.command;

import java.util.List;
import nl.rutgerkok.betterenderchest.BetterEnderChest;
import nl.rutgerkok.betterenderchest.BetterEnderUtils;
import nl.rutgerkok.betterenderchest.Translations;
import nl.rutgerkok.betterenderchest.WorldGroup;
import nl.rutgerkok.betterenderchest.command.BaseCommand;
import nl.rutgerkok.betterenderchest.io.Consumer;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.Inventory;

public class DeleteInvCommand
extends BaseCommand {
    public DeleteInvCommand(BetterEnderChest plugin) {
        super(plugin);
    }

    @Override
    public List<String> autoComplete(CommandSender sender, String[] args) {
        if (args.length == 1) {
            return null;
        }
        return super.autoComplete(sender, args);
    }

    @Override
    public boolean execute(final CommandSender sender, String[] args) {
        if (args.length != 1) {
            return false;
        }
        String inventoryName = this.getInventoryName(args[0]);
        WorldGroup group = this.getGroup(args[0], sender);
        if (group == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + Translations.GROUP_NOT_FOUND.toString(args[0]));
            return true;
        }
        this.getInventory(sender, inventoryName, group, new Consumer<Inventory>(){

            @Override
            public void consume(Inventory inventory) {
                BetterEnderUtils.closeInventory(inventory, String.valueOf(ChatColor.YELLOW) + Translations.DELETE_INV_ADMIN_DELETED_INVENTORY.toString());
                inventory.clear();
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + Translations.DELETE_INV_SUCCESSFULLY_REMOVED_INVENTORY.toString());
            }
        });
        return true;
    }

    @Override
    public String getHelpText() {
        return Translations.DELETE_INV_HELP_TEXT.toString();
    }

    @Override
    public String getName() {
        return Translations.DELETE_COMMAND.toString();
    }

    @Override
    public String getUsage() {
        return Translations.DELETE_INV_USAGE.toString();
    }
}

