/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest.chestowner;

import java.util.UUID;
import nl.rutgerkok.betterenderchest.Translations;
import nl.rutgerkok.betterenderchest.chestowner.ChestOwner;
import org.apache.commons.lang3.Validate;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

final class UUIDChestOwner
implements ChestOwner {
    private final String displayName;
    private final UUID uuid;

    UUIDChestOwner(String displayName, UUID uuid) {
        Validate.notNull((Object)displayName, (String)"Name may not be null", (Object[])new Object[0]);
        Validate.notNull((Object)uuid, (String)"UUID may not be null", (Object[])new Object[0]);
        this.displayName = displayName;
        this.uuid = uuid;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof UUIDChestOwner)) {
            return false;
        }
        return ((UUIDChestOwner)other).uuid.equals(this.uuid);
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getInventoryTitle() {
        return Translations.PRIVATE_CHEST_TITLE.toString(this.displayName);
    }

    @Override
    public OfflinePlayer getOfflinePlayer() {
        return Bukkit.getOfflinePlayer((UUID)this.uuid);
    }

    @Override
    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.uuid);
    }

    @Override
    public String getSaveFileName() {
        return this.uuid.toString();
    }

    public int hashCode() {
        return this.uuid.hashCode() * 31;
    }

    @Override
    public boolean isDefaultChest() {
        return false;
    }

    @Override
    public boolean isOwnerOnline() {
        return Bukkit.getPlayer((UUID)this.uuid) != null;
    }

    @Override
    public boolean isPlayer(OfflinePlayer player) {
        return this.uuid.equals(player.getUniqueId());
    }

    @Override
    public boolean isPublicChest() {
        return false;
    }

    @Override
    public boolean isSpecialChest() {
        return false;
    }

    public String toString() {
        return Translations.UUID_CHEST_NAME.toString(this.uuid, this.displayName);
    }
}

