/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest.chestowner;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import nl.rutgerkok.betterenderchest.BetterEnderChest;
import nl.rutgerkok.betterenderchest.chestowner.ChestOwner;
import nl.rutgerkok.betterenderchest.chestowner.NamedChestOwner;
import nl.rutgerkok.betterenderchest.chestowner.SpecialChestOwner;
import nl.rutgerkok.betterenderchest.chestowner.UUIDChestOwner;
import nl.rutgerkok.betterenderchest.chestowner.UUIDFetcher;
import nl.rutgerkok.betterenderchest.exception.InvalidOwnerException;
import nl.rutgerkok.betterenderchest.io.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.json.simple.parser.ParseException;

public class ChestOwners {
    private final BetterEnderChest plugin;
    private final LoadingCache<String, ChestOwner> uuidCache;

    public ChestOwners(BetterEnderChest plugin) {
        this.plugin = plugin;
        this.uuidCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(60L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, ChestOwner>(){

            public ChestOwner load(String name) throws Exception {
                return ChestOwners.this.fetchProfileSync(name);
            }
        });
    }

    public ChestOwner defaultChest() {
        return SpecialChestOwner.DEFAULT_CHEST_OWNER;
    }

    private ChestOwner fetchProfileSync(String name) throws InvalidOwnerException {
        Player player = Bukkit.getPlayerExact((String)name);
        if (player != null) {
            return this.playerChest(player);
        }
        UUIDFetcher uuidFetcher = new UUIDFetcher(this.plugin, Collections.singletonList(name));
        try {
            Object chestOwnerMap = uuidFetcher.call();
            if (chestOwnerMap.size() == 0) {
                throw new InvalidOwnerException(name);
            }
            if (chestOwnerMap.size() == 1) {
                return (ChestOwner)chestOwnerMap.values().iterator().next();
            }
            this.plugin.log("Multiple UUIDs for " + name + ": " + String.valueOf(chestOwnerMap.values()));
            throw new InvalidOwnerException(name);
        }
        catch (IOException e) {
            this.plugin.log("Error communicating with mojang.com: " + e.getClass().getSimpleName() + " " + e.getMessage());
            throw new InvalidOwnerException(name);
        }
        catch (ParseException e) {
            this.plugin.log("Error communicating with mojang.com: " + ((Object)((Object)e)).getClass().getSimpleName() + " " + e.getMessage());
            throw new InvalidOwnerException(name);
        }
    }

    public void fromInput(final String name, final Consumer<ChestOwner> onSuccess, final Consumer<InvalidOwnerException> onFailure) {
        if (name.equalsIgnoreCase(this.publicChest().getSaveFileName())) {
            onSuccess.consume(this.publicChest());
            return;
        }
        if (name.equalsIgnoreCase(this.defaultChest().getSaveFileName())) {
            onSuccess.consume(this.defaultChest());
            return;
        }
        if (!this.plugin.useUuidsForSaving()) {
            onSuccess.consume(new NamedChestOwner(name));
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously(this.plugin.getPlugin(), new Runnable(){

            @Override
            public void run() {
                try {
                    final ChestOwner chestOwner = (ChestOwner)ChestOwners.this.uuidCache.get((Object)name.toLowerCase());
                    Bukkit.getScheduler().runTask(ChestOwners.this.plugin.getPlugin(), new Runnable(){

                        @Override
                        public void run() {
                            onSuccess.consume(chestOwner);
                        }
                    });
                }
                catch (ExecutionException e) {
                    Bukkit.getScheduler().runTask(ChestOwners.this.plugin.getPlugin(), new Runnable(){

                        @Override
                        public void run() {
                            if (e.getCause() instanceof InvalidOwnerException) {
                                onFailure.consume((InvalidOwnerException)e.getCause());
                            } else {
                                ChestOwners.this.plugin.severe("Unexpected error fetching uuid of " + name, e);
                                onFailure.consume(new InvalidOwnerException(name));
                            }
                        }
                    });
                }
            }
        });
    }

    public ChestOwner playerChest(Player player) {
        if (this.plugin.useUuidsForSaving()) {
            return new UUIDChestOwner(player.getName(), player.getUniqueId());
        }
        return new NamedChestOwner(player.getName());
    }

    public ChestOwner playerChest(String playerName, UUID uuid) {
        if (this.plugin.useUuidsForSaving()) {
            return new UUIDChestOwner(playerName, uuid);
        }
        return new NamedChestOwner(playerName);
    }

    public ChestOwner publicChest() {
        return SpecialChestOwner.PUBLIC_CHEST_OWNER;
    }
}

