/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest;

import nl.rutgerkok.betterenderchest.BetterEnderChest;
import nl.rutgerkok.betterenderchest.BetterEnderChestPlugin;
import nl.rutgerkok.betterenderchest.BetterEnderUtils;
import nl.rutgerkok.betterenderchest.ImmutableInventory;
import nl.rutgerkok.betterenderchest.WorldGroup;
import nl.rutgerkok.betterenderchest.chestowner.ChestOwner;
import nl.rutgerkok.betterenderchest.chestprotection.ProtectionBridge;
import nl.rutgerkok.betterenderchest.exception.ChestProtectedException;
import nl.rutgerkok.betterenderchest.exception.InvalidOwnerException;
import nl.rutgerkok.betterenderchest.exception.NoPermissionException;
import nl.rutgerkok.betterenderchest.io.Consumer;
import nl.rutgerkok.betterenderchest.nms.NMSHandler;
import org.apache.commons.lang3.Validate;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class ChestOpener {
    private final BetterEnderChest plugin;

    public ChestOpener(BetterEnderChest plugin) {
        Validate.notNull((Object)plugin, (String)"plugin is null", (Object[])new Object[0]);
        this.plugin = plugin;
    }

    private void checkPermission(Player player, String permission) throws NoPermissionException {
        if (!player.hasPermission(permission)) {
            throw new NoPermissionException(permission);
        }
    }

    public void getBlockInventory(Player player, Block block, final Consumer<Inventory> callback) throws IllegalArgumentException, NoPermissionException, ChestProtectedException {
        Validate.notNull((Object)player, (String)"player may not be null", (Object[])new Object[0]);
        Validate.notNull((Object)block, (String)"block may not be null", (Object[])new Object[0]);
        Validate.notNull(callback, (String)"callback may not be null", (Object[])new Object[0]);
        final WorldGroup worldGroup = this.plugin.getWorldGroupManager().getGroupByWorld(block.getWorld());
        if (block.getType() != this.plugin.getChestMaterial()) {
            throw new IllegalArgumentException("Invalid block, must be of type " + String.valueOf(this.plugin.getChestMaterial()) + ", but is of type " + String.valueOf(block.getType()));
        }
        ProtectionBridge bridge = this.plugin.getProtectionBridges().getSelectedRegistration();
        if (bridge.isProtected(block)) {
            if (!bridge.canAccess(player, block)) {
                throw new ChestProtectedException();
            }
            this.checkPermission(player, "betterenderchest.user.open.privatechest");
            ChestOwner chestOwner = bridge.getChestOwner(block);
            if (chestOwner != null) {
                this.plugin.getChestCache().getInventory(chestOwner, worldGroup, callback);
                return;
            }
            final String inventoryName = bridge.getOwnerName(block);
            this.plugin.getChestOwners().fromInput(inventoryName, new Consumer<ChestOwner>(){

                @Override
                public void consume(ChestOwner chestOwner) {
                    ChestOpener.this.plugin.getChestCache().getInventory(chestOwner, worldGroup, callback);
                }
            }, new Consumer<InvalidOwnerException>(){

                @Override
                public void consume(InvalidOwnerException e) {
                    ChestOpener.this.plugin.severe("Could not open chest of " + inventoryName);
                }
            });
        } else if (BetterEnderChestPlugin.PublicChest.openOnOpeningUnprotectedChest) {
            this.checkPermission(player, "betterenderchest.user.open.publicchest");
            ChestOwner chestOwner = this.plugin.getChestOwners().publicChest();
            this.plugin.getChestCache().getInventory(chestOwner, worldGroup, callback);
        } else {
            this.checkPermission(player, "betterenderchest.user.open.privatechest");
            ChestOwner chestOwner = this.plugin.getChestOwners().playerChest(player);
            this.plugin.getChestCache().getInventory(chestOwner, worldGroup, callback);
        }
    }

    public Consumer<Inventory> showAnimatedInventory(final Player player, final Block block) {
        return new Consumer<Inventory>(){

            @Override
            public void consume(Inventory inventory) {
                inventory = BetterEnderUtils.getCorrectlyResizedInventory(player, inventory, ChestOpener.this.plugin);
                player.openInventory(inventory);
                NMSHandler nmsHandler = ChestOpener.this.plugin.getNMSHandlers().getSelectedRegistration();
                if (nmsHandler != null) {
                    nmsHandler.openEnderChest(block.getLocation(), player);
                }
                BetterEnderUtils.setLastEnderChestOpeningLocation(player, block.getLocation(), ChestOpener.this.plugin);
            }
        };
    }

    public Consumer<Inventory> showInventory(final Player player) {
        return new Consumer<Inventory>(){

            @Override
            public void consume(Inventory inventory) {
                inventory = BetterEnderUtils.getCorrectlyResizedInventory(player, inventory, ChestOpener.this.plugin);
                player.openInventory(inventory);
            }
        };
    }

    public Consumer<Inventory> showUnchangeableInventory(final Player player) {
        return new Consumer<Inventory>(){

            @Override
            public void consume(Inventory inventory) {
                player.openInventory(ImmutableInventory.copyOf(inventory));
            }
        };
    }
}

