/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest;

import nl.rutgerkok.betterenderchest.BetterEnderChest;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public enum ChestDrop {
    ENDER_PEARL,
    EYE_OF_ENDER,
    ITSELF,
    NOTHING,
    OBSIDIAN,
    OBSIDIAN_WITH_ENDER_PEARL,
    OBSIDIAN_WITH_EYE_OF_ENDER;


    public void drop(BlockBreakEvent event, BetterEnderChest plugin) {
        if (event.getPlayer().getGameMode() == GameMode.CREATIVE) {
            this.dropCreative(event, plugin);
            return;
        }
        ItemStack inHand = event.getPlayer().getInventory().getItemInMainHand();
        if (inHand.getEnchantments().containsKey(Enchantment.SILK_TOUCH)) {
            this.dropSilkTouch(event);
            return;
        }
        this.dropNormally(event, plugin);
    }

    private void dropCreative(BlockBreakEvent event, BetterEnderChest plugin) {
        Location dropLocation = event.getBlock().getLocation();
        switch (this.ordinal()) {
            case 0: {
                dropLocation.getWorld().dropItemNaturally(dropLocation, new ItemStack(Material.ENDER_PEARL));
                break;
            }
            case 1: {
                dropLocation.getWorld().dropItemNaturally(dropLocation, new ItemStack(Material.ENDER_EYE));
                break;
            }
            case 2: {
                dropLocation.getWorld().dropItemNaturally(dropLocation, new ItemStack(plugin.getChestMaterial()));
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                dropLocation.getWorld().dropItemNaturally(dropLocation, new ItemStack(Material.OBSIDIAN, 8));
                break;
            }
            case 5: {
                dropLocation.getWorld().dropItemNaturally(dropLocation, new ItemStack(Material.OBSIDIAN, 8));
                dropLocation.getWorld().dropItemNaturally(dropLocation, new ItemStack(Material.ENDER_PEARL));
                break;
            }
            case 6: {
                dropLocation.getWorld().dropItemNaturally(dropLocation, new ItemStack(Material.OBSIDIAN, 8));
                dropLocation.getWorld().dropItemNaturally(dropLocation, new ItemStack(Material.ENDER_EYE));
            }
        }
    }

    private void dropNormally(BlockBreakEvent event, BetterEnderChest plugin) {
        Location dropLocation = event.getBlock().getLocation();
        switch (this.ordinal()) {
            case 0: {
                event.setCancelled(true);
                event.getBlock().setType(Material.AIR);
                dropLocation.getWorld().dropItemNaturally(dropLocation, new ItemStack(Material.ENDER_PEARL));
                break;
            }
            case 1: {
                event.setCancelled(true);
                event.getBlock().setType(Material.AIR);
                dropLocation.getWorld().dropItemNaturally(dropLocation, new ItemStack(Material.ENDER_EYE));
                break;
            }
            case 2: {
                event.setCancelled(true);
                event.getBlock().setType(Material.AIR);
                dropLocation.getWorld().dropItemNaturally(dropLocation, new ItemStack(plugin.getChestMaterial()));
                break;
            }
            case 3: {
                event.setCancelled(true);
                event.getBlock().setType(Material.AIR);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                dropLocation.getWorld().dropItemNaturally(dropLocation, new ItemStack(Material.ENDER_PEARL));
                break;
            }
            case 6: {
                dropLocation.getWorld().dropItemNaturally(dropLocation, new ItemStack(Material.ENDER_EYE));
            }
        }
    }

    private void dropSilkTouch(BlockBreakEvent event) {
        Location dropLocation = event.getBlock().getLocation();
        switch (this.ordinal()) {
            case 0: {
                event.setCancelled(true);
                event.getBlock().setType(Material.AIR);
                dropLocation.getWorld().dropItemNaturally(dropLocation, new ItemStack(Material.ENDER_PEARL));
                break;
            }
            case 1: {
                event.setCancelled(true);
                event.getBlock().setType(Material.AIR);
                dropLocation.getWorld().dropItemNaturally(dropLocation, new ItemStack(Material.ENDER_EYE));
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                event.setCancelled(true);
                event.getBlock().setType(Material.AIR);
                break;
            }
            case 4: {
                event.setCancelled(true);
                event.getBlock().setType(Material.AIR);
                dropLocation.getWorld().dropItemNaturally(dropLocation, new ItemStack(Material.OBSIDIAN, 8));
                break;
            }
            case 5: {
                event.setCancelled(true);
                event.getBlock().setType(Material.AIR);
                dropLocation.getWorld().dropItemNaturally(dropLocation, new ItemStack(Material.OBSIDIAN, 8));
                dropLocation.getWorld().dropItemNaturally(dropLocation, new ItemStack(Material.ENDER_PEARL));
                break;
            }
            case 6: {
                event.setCancelled(true);
                event.getBlock().setType(Material.AIR);
                dropLocation.getWorld().dropItemNaturally(dropLocation, new ItemStack(Material.OBSIDIAN, 8));
                dropLocation.getWorld().dropItemNaturally(dropLocation, new ItemStack(Material.ENDER_EYE));
            }
        }
    }
}

