/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.rutgerkok.betterenderchest.BetterEnderChestPlugin;
import nl.rutgerkok.betterenderchest.WorldGroup;
import nl.rutgerkok.betterenderchest.importers.InventoryImporter;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class BetterEnderWorldGroupManager {
    private Map<String, WorldGroup> groups;
    private BetterEnderChestPlugin plugin;

    public BetterEnderWorldGroupManager(BetterEnderChestPlugin plugin) {
        this.plugin = plugin;
        this.groups = new HashMap<String, WorldGroup>();
    }

    public WorldGroup getGroupByGroupName(String groupName) {
        return this.groups.get(groupName.toLowerCase());
    }

    public WorldGroup getGroupByWorld(World world) {
        return this.getGroupByWorldName(world.getName());
    }

    public WorldGroup getGroupByWorldName(String worldName) {
        for (WorldGroup worldGroup : this.groups.values()) {
            if (!worldGroup.isWorldInGroup(worldName)) continue;
            return worldGroup;
        }
        return this.getOrCreateWorldGroup("default");
    }

    public List<WorldGroup> getGroups() {
        return ImmutableList.copyOf(this.groups.values());
    }

    protected WorldGroup getOrCreateWorldGroup(String groupName) {
        WorldGroup group = this.groups.get(groupName = groupName.toLowerCase());
        if (group == null) {
            group = new WorldGroup(groupName);
            this.groups.put(groupName, group);
        }
        return group;
    }

    public WorldGroup getStandardWorldGroup() {
        return this.getOrCreateWorldGroup("default");
    }

    public boolean groupExists(String name) {
        return this.groups.containsKey(name.toLowerCase());
    }

    public void initConfig() {
        if (this.groups.size() >= 1) {
            this.groups.clear();
        }
        this.readConfig();
        this.writeConfig();
    }

    public boolean isWorldListed(String worldName) {
        for (WorldGroup worldGroup : this.groups.values()) {
            if (!worldGroup.isWorldInGroup(worldName)) continue;
            return true;
        }
        return false;
    }

    public void readConfig() {
        ConfigurationSection section;
        ConfigurationSection importSection = this.plugin.getConfig().getConfigurationSection("Imports");
        if (importSection == null || !this.plugin.hasManualGroupManagement()) {
            InventoryImporter importer = this.plugin.getInventoryImporters().getSelectedRegistration();
            for (WorldGroup group : importer.importWorldGroups(this.plugin)) {
                this.groups.put(group.getGroupName(), group);
            }
        } else {
            for (String groupName : importSection.getValues(false).keySet()) {
                String importerName = importSection.getString(groupName).toLowerCase();
                InventoryImporter importer = this.plugin.getInventoryImporters().getAvailableRegistration(importerName);
                if (importer == null) {
                    this.plugin.warning("The import " + importerName + " for the group " + groupName + " isn't a valid importer.");
                    continue;
                }
                WorldGroup group = this.getOrCreateWorldGroup(groupName);
                group.setInventoryImporter(importer);
            }
        }
        if ((section = this.plugin.getConfig().getConfigurationSection("Groups")) != null) {
            for (String groupName : section.getValues(false).keySet()) {
                List worldsInGroup = section.getStringList(groupName);
                for (String world : worldsInGroup) {
                    if (!this.isWorldListed(world)) {
                        WorldGroup group = this.getOrCreateWorldGroup(groupName);
                        group.addWorld(world);
                        continue;
                    }
                    this.plugin.warning("The world " + world + " was added to two groups. It is now only in the first group.");
                }
            }
        }
    }

    private void writeConfig() {
        FileConfiguration config = this.plugin.getConfig();
        config.set("Groups", null);
        config.set("Imports", null);
        if (this.plugin.hasManualGroupManagement()) {
            for (WorldGroup group : this.groups.values()) {
                if (!group.hasWorlds()) continue;
                config.set("Groups." + group.getGroupName(), group.getWorldNames());
                config.set("Imports." + group.getGroupName(), (Object)group.getInventoryImporter().getName());
            }
        }
    }
}

