/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import nl.rutgerkok.betterenderchest.BetterEnderChest;
import nl.rutgerkok.betterenderchest.BetterEnderChestSizes;
import nl.rutgerkok.betterenderchest.BetterEnderInventoryHolder;
import nl.rutgerkok.betterenderchest.ChestRestrictions;
import nl.rutgerkok.betterenderchest.EmptyInventoryProvider;
import nl.rutgerkok.betterenderchest.Translations;
import nl.rutgerkok.betterenderchest.WorldGroup;
import nl.rutgerkok.betterenderchest.chestowner.ChestOwner;
import org.bukkit.ChatColor;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Tag;
import org.bukkit.block.BlockState;
import org.bukkit.block.ShulkerBox;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.metadata.Metadatable;

public class BetterEnderUtils {
    private static final String LAST_CHEST_X = "BECLastChestX";
    private static final String LAST_CHEST_Y = "BECLastChestY";
    private static final String LAST_CHEST_Z = "BECLastChestZ";

    public static void closeInventory(Inventory inventory, String message) {
        ImmutableList viewers = ImmutableList.copyOf((Collection)inventory.getViewers());
        for (HumanEntity player : viewers) {
            player.closeInventory();
            if (!(player instanceof Player)) continue;
            ((Player)player).sendMessage(message);
        }
    }

    public static void copyContents(Inventory oldInventory, Inventory newInventory, Location dropLocation) {
        int sizeNew = newInventory.getSize();
        ArrayList<ItemStack> overflowing = new ArrayList<ItemStack>();
        if (oldInventory.getHolder() instanceof BetterEnderInventoryHolder) {
            overflowing.addAll(((BetterEnderInventoryHolder)oldInventory.getHolder()).handleOverflowingItems());
        }
        ListIterator it = oldInventory.iterator();
        while (it.hasNext()) {
            int slot = it.nextIndex();
            ItemStack stack = (ItemStack)it.next();
            if (stack == null) continue;
            if (slot < sizeNew) {
                newInventory.setItem(slot, stack);
                continue;
            }
            overflowing.add(stack);
        }
        for (ItemStack stack : overflowing) {
            HashMap excess = newInventory.addItem(new ItemStack[]{stack});
            for (ItemStack excessStack : excess.values()) {
                if (dropLocation == null) continue;
                dropLocation.getWorld().dropItem(dropLocation, excessStack);
            }
        }
    }

    public static void dropItemsInDisabledSlots(Inventory inventory, Player player, BetterEnderChest plugin) {
        BetterEnderInventoryHolder holder = (BetterEnderInventoryHolder)inventory.getHolder();
        ChestOwner chestOwner = holder.getChestOwner();
        int disabledSlots = holder.getChestRestrictions().getDisabledSlots();
        if (disabledSlots > 0) {
            Location playerLocation = player.getLocation();
            int droppedCount = 0;
            for (int i = 1; i <= disabledSlots; ++i) {
                ItemStack stackInDisabledSlot = inventory.getItem(inventory.getSize() - i);
                if (stackInDisabledSlot == null || stackInDisabledSlot.getType().equals((Object)Material.AIR)) continue;
                inventory.setItem(inventory.getSize() - i, new ItemStack(Material.AIR));
                player.getWorld().dropItemNaturally(playerLocation, stackInDisabledSlot);
                ++droppedCount;
            }
            if (droppedCount > 0) {
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + Translations.OVERFLOWING_CHEST_CLOSE.toString());
                plugin.log("There were items in disabled slots in the Ender Chest of " + chestOwner.getDisplayName() + ". Demoted? Glitch? Hacking? " + droppedCount + " stacks are ejected.");
            }
        }
    }

    public static Inventory getCorrectlyResizedInventory(Player player, Inventory inventory, BetterEnderChest plugin) {
        Inventory resizedInventory = BetterEnderUtils.getResizedEmptyInventory(player, inventory, plugin);
        if (resizedInventory != null) {
            BetterEnderUtils.closeInventory(inventory, String.valueOf(ChatColor.YELLOW) + "The owner got a different rank, and the inventory had to be resized.");
            BetterEnderUtils.copyContents(inventory, resizedInventory, player.getLocation());
            plugin.getChestCache().setInventory(resizedInventory);
            inventory = resizedInventory;
        }
        return inventory;
    }

    public static Location getLastEnderChestOpeningLocation(Player player) {
        MetadataValue x = BetterEnderUtils.getMetadataValue(LAST_CHEST_X, (Metadatable)player);
        MetadataValue y = BetterEnderUtils.getMetadataValue(LAST_CHEST_Y, (Metadatable)player);
        MetadataValue z = BetterEnderUtils.getMetadataValue(LAST_CHEST_Z, (Metadatable)player);
        if (x != null && y != null && z != null) {
            return new Location(player.getWorld(), (double)x.asInt(), (double)y.asInt(), (double)z.asInt());
        }
        return null;
    }

    private static MetadataValue getMetadataValue(String key, Metadatable lookup) {
        if (lookup == null) {
            return null;
        }
        List values = lookup.getMetadata(key);
        if (values == null || values.size() == 0) {
            return null;
        }
        return (MetadataValue)values.get(0);
    }

    private static Inventory getResizedEmptyInventory(Player player, Inventory inventory, BetterEnderChest plugin) {
        BetterEnderInventoryHolder inventoryHolder = BetterEnderInventoryHolder.of(inventory);
        ChestOwner chestOwner = inventoryHolder.getChestOwner();
        WorldGroup worldGroup = inventoryHolder.getWorldGroup();
        ChestRestrictions chestRestrictions = inventoryHolder.getChestRestrictions();
        BetterEnderChestSizes chestSizes = plugin.getChestSizes();
        EmptyInventoryProvider emptyChests = plugin.getEmptyInventoryProvider();
        ChestRestrictions desiredRestrictions = null;
        if (chestOwner.isPublicChest()) {
            desiredRestrictions = chestSizes.getPublicChestRestrictions();
        } else if (chestOwner.isDefaultChest()) {
            desiredRestrictions = chestSizes.getDefaultChestRestrictions();
        } else if (chestOwner.isPlayer((OfflinePlayer)player)) {
            desiredRestrictions = chestSizes.getChestRestrictions(player);
        }
        if ((desiredRestrictions == null || desiredRestrictions.equals(chestRestrictions)) && !inventoryHolder.hasOverflowingItems()) {
            return null;
        }
        return emptyChests.loadEmptyInventory(chestOwner, worldGroup, desiredRestrictions);
    }

    public static boolean isInventoryEmpty(Inventory inventory) {
        boolean empty = true;
        for (ItemStack stack : inventory) {
            if (stack == null || stack.getType() == Material.AIR) continue;
            empty = false;
        }
        return empty;
    }

    public static void setLastEnderChestOpeningLocation(Player player, Location location, BetterEnderChest plugin) {
        player.removeMetadata(LAST_CHEST_X, plugin.getPlugin());
        player.removeMetadata(LAST_CHEST_Y, plugin.getPlugin());
        player.removeMetadata(LAST_CHEST_Z, plugin.getPlugin());
        if (location != null) {
            player.setMetadata(LAST_CHEST_X, (MetadataValue)new FixedMetadataValue(plugin.getPlugin(), (Object)location.getBlockX()));
            player.setMetadata(LAST_CHEST_Y, (MetadataValue)new FixedMetadataValue(plugin.getPlugin(), (Object)location.getBlockY()));
            player.setMetadata(LAST_CHEST_Z, (MetadataValue)new FixedMetadataValue(plugin.getPlugin(), (Object)location.getBlockZ()));
        }
    }

    public static int inventoryHashCode(ItemStack[] contents) {
        int result = 1;
        for (ItemStack item : contents) {
            int itemHashCode = 0;
            if (item != null) {
                BlockStateMeta blockStateMeta;
                BlockState blockState;
                ItemMeta meta;
                if (Tag.SHULKER_BOXES.isTagged((Keyed)item.getType()) && (meta = item.getItemMeta()) instanceof BlockStateMeta && (blockState = (blockStateMeta = (BlockStateMeta)meta).getBlockState()) instanceof ShulkerBox) {
                    ShulkerBox shulkerBox = (ShulkerBox)blockState;
                    itemHashCode = BetterEnderUtils.inventoryHashCode(shulkerBox.getInventory().getContents());
                }
                if (itemHashCode == 0) {
                    itemHashCode = item.hashCode();
                }
            }
            result = 31 * result + itemHashCode;
        }
        return result;
    }
}

