/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.betterenderchest;

import nl.rutgerkok.betterenderchest.ChestRestrictions;
import org.bukkit.entity.Player;

public class BetterEnderChestSizes {
    private int[] playerChestDisabledSlots;
    private int[] playerChestRows;
    private int publicChestDisabledSlots;
    private int publicChestRows;

    private boolean getAllowInsert(Player player) {
        return player.hasPermission("betterenderchest.user.insert");
    }

    public int getDefaultChestRows() {
        return this.getChestRows(0);
    }

    private int getChestRows(int upgrade) throws ArrayIndexOutOfBoundsException {
        return this.playerChestRows[upgrade];
    }

    private int getChestRows(Player player) {
        for (int i = this.playerChestRows.length - 1; i > 0; --i) {
            if (!player.hasPermission("betterenderchest.slots.upgrade" + i)) continue;
            return this.getChestRows(i);
        }
        return this.getDefaultChestRows();
    }

    private int getDisabledSlots() {
        return this.getDisabledSlots(0);
    }

    private int getDisabledSlots(int upgrade) throws ArrayIndexOutOfBoundsException {
        return this.playerChestDisabledSlots[upgrade];
    }

    private int getDisabledSlots(Player player) {
        for (int i = this.playerChestDisabledSlots.length - 1; i > 0; --i) {
            if (!player.hasPermission("betterenderchest.slots.upgrade" + i)) continue;
            return this.getDisabledSlots(i);
        }
        return this.getDisabledSlots();
    }

    public int getPublicChestDisabledSlots() {
        return this.publicChestDisabledSlots;
    }

    public int getPublicChestRows() {
        return this.publicChestRows;
    }

    public int getUpgradeCount() {
        return this.playerChestRows.length - 1;
    }

    public void setSizes(int publicChestSlots, int[] playerChestSlots) {
        this.publicChestRows = (publicChestSlots + 8) / 9;
        this.publicChestDisabledSlots = this.publicChestRows * 9 - publicChestSlots;
        this.playerChestRows = new int[playerChestSlots.length];
        this.playerChestDisabledSlots = new int[playerChestSlots.length];
        for (int i = 0; i < this.playerChestRows.length; ++i) {
            this.playerChestRows[i] = (playerChestSlots[i] + 8) / 9;
            this.playerChestDisabledSlots[i] = this.playerChestRows[i] * 9 - playerChestSlots[i];
        }
    }

    public ChestRestrictions getChestRestrictions(Player player) {
        return new ChestRestrictions(this.getChestRows(player), this.getDisabledSlots(player), this.getAllowInsert(player));
    }

    public ChestRestrictions getPublicChestRestrictions() {
        return new ChestRestrictions(this.getPublicChestRows(), this.getPublicChestDisabledSlots(), true);
    }

    public ChestRestrictions getDefaultChestRestrictions() {
        return new ChestRestrictions(this.getDefaultChestRows(), this.getDisabledSlots(), true);
    }
}

